<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Money StructType
 * @subpackage Structs
 */
class Money extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The currency_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currency_code;
    /**
     * Constructor method for Money
     * @uses Money::setAmount()
     * @uses Money::setCurrency_code()
     * @param float $amount
     * @param string $currency_code
     */
    public function __construct($amount = null, $currency_code = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency_code($currency_code);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\Money
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency_code()
    {
        return isset($this->currency_code) ? $this->currency_code : null;
    }
    /**
     * Set currency_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency_code
     * @return \StructType\Money
     */
    public function setCurrency_code($currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($currency_code) && !is_string($currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency_code, true), gettype($currency_code)), __LINE__);
        }
        if (is_null($currency_code) || (is_array($currency_code) && empty($currency_code))) {
            unset($this->currency_code);
        } else {
            $this->currency_code = $currency_code;
        }
        return $this;
    }
}
