<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for get_voucher_status StructType
 * @subpackage Structs
 */
class Get_voucher_status extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credential
     */
    public $login;
    /**
     * The mfs_trans_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mfs_trans_id;
    /**
     * The voucher_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voucher_code;
    /**
     * The voucher_partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voucher_partner;
    /**
     * The urlConfirmation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $urlConfirmation;
    /**
     * Constructor method for get_voucher_status
     * @uses Get_voucher_status::setLogin()
     * @uses Get_voucher_status::setMfs_trans_id()
     * @uses Get_voucher_status::setVoucher_code()
     * @uses Get_voucher_status::setVoucher_partner()
     * @uses Get_voucher_status::setUrlConfirmation()
     * @param \StructType\Credential $login
     * @param string $mfs_trans_id
     * @param string $voucher_code
     * @param string $voucher_partner
     * @param string $urlConfirmation
     */
    public function __construct(\StructType\Credential $login = null, $mfs_trans_id = null, $voucher_code = null, $voucher_partner = null, $urlConfirmation = null)
    {
        $this
            ->setLogin($login)
            ->setMfs_trans_id($mfs_trans_id)
            ->setVoucher_code($voucher_code)
            ->setVoucher_partner($voucher_partner)
            ->setUrlConfirmation($urlConfirmation);
    }
    /**
     * Get login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credential|null
     */
    public function getLogin()
    {
        return isset($this->login) ? $this->login : null;
    }
    /**
     * Set login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credential $login
     * @return \StructType\Get_voucher_status
     */
    public function setLogin(\StructType\Credential $login = null)
    {
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->login);
        } else {
            $this->login = $login;
        }
        return $this;
    }
    /**
     * Get mfs_trans_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMfs_trans_id()
    {
        return isset($this->mfs_trans_id) ? $this->mfs_trans_id : null;
    }
    /**
     * Set mfs_trans_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mfs_trans_id
     * @return \StructType\Get_voucher_status
     */
    public function setMfs_trans_id($mfs_trans_id = null)
    {
        // validation for constraint: string
        if (!is_null($mfs_trans_id) && !is_string($mfs_trans_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfs_trans_id, true), gettype($mfs_trans_id)), __LINE__);
        }
        if (is_null($mfs_trans_id) || (is_array($mfs_trans_id) && empty($mfs_trans_id))) {
            unset($this->mfs_trans_id);
        } else {
            $this->mfs_trans_id = $mfs_trans_id;
        }
        return $this;
    }
    /**
     * Get voucher_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucher_code()
    {
        return isset($this->voucher_code) ? $this->voucher_code : null;
    }
    /**
     * Set voucher_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucher_code
     * @return \StructType\Get_voucher_status
     */
    public function setVoucher_code($voucher_code = null)
    {
        // validation for constraint: string
        if (!is_null($voucher_code) && !is_string($voucher_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher_code, true), gettype($voucher_code)), __LINE__);
        }
        if (is_null($voucher_code) || (is_array($voucher_code) && empty($voucher_code))) {
            unset($this->voucher_code);
        } else {
            $this->voucher_code = $voucher_code;
        }
        return $this;
    }
    /**
     * Get voucher_partner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucher_partner()
    {
        return isset($this->voucher_partner) ? $this->voucher_partner : null;
    }
    /**
     * Set voucher_partner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucher_partner
     * @return \StructType\Get_voucher_status
     */
    public function setVoucher_partner($voucher_partner = null)
    {
        // validation for constraint: string
        if (!is_null($voucher_partner) && !is_string($voucher_partner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher_partner, true), gettype($voucher_partner)), __LINE__);
        }
        if (is_null($voucher_partner) || (is_array($voucher_partner) && empty($voucher_partner))) {
            unset($this->voucher_partner);
        } else {
            $this->voucher_partner = $voucher_partner;
        }
        return $this;
    }
    /**
     * Get urlConfirmation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlConfirmation()
    {
        return isset($this->urlConfirmation) ? $this->urlConfirmation : null;
    }
    /**
     * Set urlConfirmation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlConfirmation
     * @return \StructType\Get_voucher_status
     */
    public function setUrlConfirmation($urlConfirmation = null)
    {
        // validation for constraint: string
        if (!is_null($urlConfirmation) && !is_string($urlConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlConfirmation, true), gettype($urlConfirmation)), __LINE__);
        }
        if (is_null($urlConfirmation) || (is_array($urlConfirmation) && empty($urlConfirmation))) {
            unset($this->urlConfirmation);
        } else {
            $this->urlConfirmation = $urlConfirmation;
        }
        return $this;
    }
}
