<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transcom ServiceType
 * @subpackage Services
 */
class Transcom extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named trans_com
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Trans_com $parameters
     * @return \StructType\Trans_comResponse|bool
     */
    public function trans_com(\StructType\Trans_com $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->trans_com($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Trans_comResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
