<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Canceltrans ServiceType
 * @subpackage Services
 */
class Canceltrans extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancel_trans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_trans $parameters
     * @return \StructType\Cancel_transResponse|bool
     */
    public function cancel_trans(\StructType\Cancel_trans $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cancel_trans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Cancel_transResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
