<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionBank StructType
 * @subpackage Structs
 */
class TransactionBank extends AbstractStructBase
{
    /**
     * The fx_rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fx_rate;
    /**
     * The mfs_trans_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mfs_trans_id;
    /**
     * The receive_amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Money
     */
    public $receive_amount;
    /**
     * The send_amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Money
     */
    public $send_amount;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MResponse
     */
    public $status;
    /**
     * The third_party_trans_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $third_party_trans_id;
    /**
     * Constructor method for TransactionBank
     * @uses TransactionBank::setFx_rate()
     * @uses TransactionBank::setMfs_trans_id()
     * @uses TransactionBank::setReceive_amount()
     * @uses TransactionBank::setSend_amount()
     * @uses TransactionBank::setStatus()
     * @uses TransactionBank::setThird_party_trans_id()
     * @param float $fx_rate
     * @param string $mfs_trans_id
     * @param \StructType\Money $receive_amount
     * @param \StructType\Money $send_amount
     * @param \StructType\MResponse $status
     * @param string $third_party_trans_id
     */
    public function __construct($fx_rate = null, $mfs_trans_id = null, \StructType\Money $receive_amount = null, \StructType\Money $send_amount = null, \StructType\MResponse $status = null, $third_party_trans_id = null)
    {
        $this
            ->setFx_rate($fx_rate)
            ->setMfs_trans_id($mfs_trans_id)
            ->setReceive_amount($receive_amount)
            ->setSend_amount($send_amount)
            ->setStatus($status)
            ->setThird_party_trans_id($third_party_trans_id);
    }
    /**
     * Get fx_rate value
     * @return float|null
     */
    public function getFx_rate()
    {
        return $this->fx_rate;
    }
    /**
     * Set fx_rate value
     * @param float $fx_rate
     * @return \StructType\TransactionBank
     */
    public function setFx_rate($fx_rate = null)
    {
        // validation for constraint: float
        if (!is_null($fx_rate) && !(is_float($fx_rate) || is_numeric($fx_rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fx_rate, true), gettype($fx_rate)), __LINE__);
        }
        $this->fx_rate = $fx_rate;
        return $this;
    }
    /**
     * Get mfs_trans_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMfs_trans_id()
    {
        return isset($this->mfs_trans_id) ? $this->mfs_trans_id : null;
    }
    /**
     * Set mfs_trans_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mfs_trans_id
     * @return \StructType\TransactionBank
     */
    public function setMfs_trans_id($mfs_trans_id = null)
    {
        // validation for constraint: string
        if (!is_null($mfs_trans_id) && !is_string($mfs_trans_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfs_trans_id, true), gettype($mfs_trans_id)), __LINE__);
        }
        if (is_null($mfs_trans_id) || (is_array($mfs_trans_id) && empty($mfs_trans_id))) {
            unset($this->mfs_trans_id);
        } else {
            $this->mfs_trans_id = $mfs_trans_id;
        }
        return $this;
    }
    /**
     * Get receive_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Money|null
     */
    public function getReceive_amount()
    {
        return isset($this->receive_amount) ? $this->receive_amount : null;
    }
    /**
     * Set receive_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Money $receive_amount
     * @return \StructType\TransactionBank
     */
    public function setReceive_amount(\StructType\Money $receive_amount = null)
    {
        if (is_null($receive_amount) || (is_array($receive_amount) && empty($receive_amount))) {
            unset($this->receive_amount);
        } else {
            $this->receive_amount = $receive_amount;
        }
        return $this;
    }
    /**
     * Get send_amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Money|null
     */
    public function getSend_amount()
    {
        return isset($this->send_amount) ? $this->send_amount : null;
    }
    /**
     * Set send_amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Money $send_amount
     * @return \StructType\TransactionBank
     */
    public function setSend_amount(\StructType\Money $send_amount = null)
    {
        if (is_null($send_amount) || (is_array($send_amount) && empty($send_amount))) {
            unset($this->send_amount);
        } else {
            $this->send_amount = $send_amount;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MResponse|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MResponse $status
     * @return \StructType\TransactionBank
     */
    public function setStatus(\StructType\MResponse $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get third_party_trans_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThird_party_trans_id()
    {
        return isset($this->third_party_trans_id) ? $this->third_party_trans_id : null;
    }
    /**
     * Set third_party_trans_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $third_party_trans_id
     * @return \StructType\TransactionBank
     */
    public function setThird_party_trans_id($third_party_trans_id = null)
    {
        // validation for constraint: string
        if (!is_null($third_party_trans_id) && !is_string($third_party_trans_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($third_party_trans_id, true), gettype($third_party_trans_id)), __LINE__);
        }
        if (is_null($third_party_trans_id) || (is_array($third_party_trans_id) && empty($third_party_trans_id))) {
            unset($this->third_party_trans_id);
        } else {
            $this->third_party_trans_id = $third_party_trans_id;
        }
        return $this;
    }
}
