<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Limit StructType
 * @subpackage Structs
 */
class Limit extends AbstractStructBase
{
    /**
     * The max_daily_value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $max_daily_value;
    /**
     * The max_monthly_value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $max_monthly_value;
    /**
     * The max_per_tx_limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $max_per_tx_limit;
    /**
     * The max_weekly_value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $max_weekly_value;
    /**
     * The min_per_tx_limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $min_per_tx_limit;
    /**
     * Constructor method for Limit
     * @uses Limit::setMax_daily_value()
     * @uses Limit::setMax_monthly_value()
     * @uses Limit::setMax_per_tx_limit()
     * @uses Limit::setMax_weekly_value()
     * @uses Limit::setMin_per_tx_limit()
     * @param float $max_daily_value
     * @param float $max_monthly_value
     * @param float $max_per_tx_limit
     * @param float $max_weekly_value
     * @param float $min_per_tx_limit
     */
    public function __construct($max_daily_value = null, $max_monthly_value = null, $max_per_tx_limit = null, $max_weekly_value = null, $min_per_tx_limit = null)
    {
        $this
            ->setMax_daily_value($max_daily_value)
            ->setMax_monthly_value($max_monthly_value)
            ->setMax_per_tx_limit($max_per_tx_limit)
            ->setMax_weekly_value($max_weekly_value)
            ->setMin_per_tx_limit($min_per_tx_limit);
    }
    /**
     * Get max_daily_value value
     * @return float|null
     */
    public function getMax_daily_value()
    {
        return $this->max_daily_value;
    }
    /**
     * Set max_daily_value value
     * @param float $max_daily_value
     * @return \StructType\Limit
     */
    public function setMax_daily_value($max_daily_value = null)
    {
        // validation for constraint: float
        if (!is_null($max_daily_value) && !(is_float($max_daily_value) || is_numeric($max_daily_value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max_daily_value, true), gettype($max_daily_value)), __LINE__);
        }
        $this->max_daily_value = $max_daily_value;
        return $this;
    }
    /**
     * Get max_monthly_value value
     * @return float|null
     */
    public function getMax_monthly_value()
    {
        return $this->max_monthly_value;
    }
    /**
     * Set max_monthly_value value
     * @param float $max_monthly_value
     * @return \StructType\Limit
     */
    public function setMax_monthly_value($max_monthly_value = null)
    {
        // validation for constraint: float
        if (!is_null($max_monthly_value) && !(is_float($max_monthly_value) || is_numeric($max_monthly_value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max_monthly_value, true), gettype($max_monthly_value)), __LINE__);
        }
        $this->max_monthly_value = $max_monthly_value;
        return $this;
    }
    /**
     * Get max_per_tx_limit value
     * @return float|null
     */
    public function getMax_per_tx_limit()
    {
        return $this->max_per_tx_limit;
    }
    /**
     * Set max_per_tx_limit value
     * @param float $max_per_tx_limit
     * @return \StructType\Limit
     */
    public function setMax_per_tx_limit($max_per_tx_limit = null)
    {
        // validation for constraint: float
        if (!is_null($max_per_tx_limit) && !(is_float($max_per_tx_limit) || is_numeric($max_per_tx_limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max_per_tx_limit, true), gettype($max_per_tx_limit)), __LINE__);
        }
        $this->max_per_tx_limit = $max_per_tx_limit;
        return $this;
    }
    /**
     * Get max_weekly_value value
     * @return float|null
     */
    public function getMax_weekly_value()
    {
        return $this->max_weekly_value;
    }
    /**
     * Set max_weekly_value value
     * @param float $max_weekly_value
     * @return \StructType\Limit
     */
    public function setMax_weekly_value($max_weekly_value = null)
    {
        // validation for constraint: float
        if (!is_null($max_weekly_value) && !(is_float($max_weekly_value) || is_numeric($max_weekly_value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max_weekly_value, true), gettype($max_weekly_value)), __LINE__);
        }
        $this->max_weekly_value = $max_weekly_value;
        return $this;
    }
    /**
     * Get min_per_tx_limit value
     * @return float|null
     */
    public function getMin_per_tx_limit()
    {
        return $this->min_per_tx_limit;
    }
    /**
     * Set min_per_tx_limit value
     * @param float $min_per_tx_limit
     * @return \StructType\Limit
     */
    public function setMin_per_tx_limit($min_per_tx_limit = null)
    {
        // validation for constraint: float
        if (!is_null($min_per_tx_limit) && !(is_float($min_per_tx_limit) || is_numeric($min_per_tx_limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($min_per_tx_limit, true), gettype($min_per_tx_limit)), __LINE__);
        }
        $this->min_per_tx_limit = $min_per_tx_limit;
        return $this;
    }
}
