<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airtime StructType
 * @subpackage Structs
 */
class Airtime extends AbstractStructBase
{
    /**
     * The airtime_mno_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $airtime_mno_id;
    /**
     * The airtime_mno_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $airtime_mno_name;
    /**
     * The country_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $country_code;
    /**
     * The country_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $country_name;
    /**
     * The denomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Denomination[]
     */
    public $denomination;
    /**
     * The free_range_values
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FreeRange
     */
    public $free_range_values;
    /**
     * The receive_currency_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $receive_currency_code;
    /**
     * Constructor method for Airtime
     * @uses Airtime::setAirtime_mno_id()
     * @uses Airtime::setAirtime_mno_name()
     * @uses Airtime::setCountry_code()
     * @uses Airtime::setCountry_name()
     * @uses Airtime::setDenomination()
     * @uses Airtime::setFree_range_values()
     * @uses Airtime::setReceive_currency_code()
     * @param string $airtime_mno_id
     * @param string $airtime_mno_name
     * @param string $country_code
     * @param string $country_name
     * @param \StructType\Denomination[] $denomination
     * @param \StructType\FreeRange $free_range_values
     * @param string $receive_currency_code
     */
    public function __construct($airtime_mno_id = null, $airtime_mno_name = null, $country_code = null, $country_name = null, array $denomination = array(), \StructType\FreeRange $free_range_values = null, $receive_currency_code = null)
    {
        $this
            ->setAirtime_mno_id($airtime_mno_id)
            ->setAirtime_mno_name($airtime_mno_name)
            ->setCountry_code($country_code)
            ->setCountry_name($country_name)
            ->setDenomination($denomination)
            ->setFree_range_values($free_range_values)
            ->setReceive_currency_code($receive_currency_code);
    }
    /**
     * Get airtime_mno_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirtime_mno_id()
    {
        return isset($this->airtime_mno_id) ? $this->airtime_mno_id : null;
    }
    /**
     * Set airtime_mno_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airtime_mno_id
     * @return \StructType\Airtime
     */
    public function setAirtime_mno_id($airtime_mno_id = null)
    {
        // validation for constraint: string
        if (!is_null($airtime_mno_id) && !is_string($airtime_mno_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airtime_mno_id, true), gettype($airtime_mno_id)), __LINE__);
        }
        if (is_null($airtime_mno_id) || (is_array($airtime_mno_id) && empty($airtime_mno_id))) {
            unset($this->airtime_mno_id);
        } else {
            $this->airtime_mno_id = $airtime_mno_id;
        }
        return $this;
    }
    /**
     * Get airtime_mno_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirtime_mno_name()
    {
        return isset($this->airtime_mno_name) ? $this->airtime_mno_name : null;
    }
    /**
     * Set airtime_mno_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airtime_mno_name
     * @return \StructType\Airtime
     */
    public function setAirtime_mno_name($airtime_mno_name = null)
    {
        // validation for constraint: string
        if (!is_null($airtime_mno_name) && !is_string($airtime_mno_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airtime_mno_name, true), gettype($airtime_mno_name)), __LINE__);
        }
        if (is_null($airtime_mno_name) || (is_array($airtime_mno_name) && empty($airtime_mno_name))) {
            unset($this->airtime_mno_name);
        } else {
            $this->airtime_mno_name = $airtime_mno_name;
        }
        return $this;
    }
    /**
     * Get country_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry_code()
    {
        return isset($this->country_code) ? $this->country_code : null;
    }
    /**
     * Set country_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country_code
     * @return \StructType\Airtime
     */
    public function setCountry_code($country_code = null)
    {
        // validation for constraint: string
        if (!is_null($country_code) && !is_string($country_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_code, true), gettype($country_code)), __LINE__);
        }
        if (is_null($country_code) || (is_array($country_code) && empty($country_code))) {
            unset($this->country_code);
        } else {
            $this->country_code = $country_code;
        }
        return $this;
    }
    /**
     * Get country_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry_name()
    {
        return isset($this->country_name) ? $this->country_name : null;
    }
    /**
     * Set country_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country_name
     * @return \StructType\Airtime
     */
    public function setCountry_name($country_name = null)
    {
        // validation for constraint: string
        if (!is_null($country_name) && !is_string($country_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_name, true), gettype($country_name)), __LINE__);
        }
        if (is_null($country_name) || (is_array($country_name) && empty($country_name))) {
            unset($this->country_name);
        } else {
            $this->country_name = $country_name;
        }
        return $this;
    }
    /**
     * Get denomination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Denomination[]|null
     */
    public function getDenomination()
    {
        return isset($this->denomination) ? $this->denomination : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDenominationForArrayConstraintsFromSetDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airtimeDenominationItem) {
            // validation for constraint: itemType
            if (!$airtimeDenominationItem instanceof \StructType\Denomination) {
                $invalidValues[] = is_object($airtimeDenominationItem) ? get_class($airtimeDenominationItem) : sprintf('%s(%s)', gettype($airtimeDenominationItem), var_export($airtimeDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The denomination property can only contain items of type \StructType\Denomination, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set denomination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Denomination[] $denomination
     * @return \StructType\Airtime
     */
    public function setDenomination(array $denomination = array())
    {
        // validation for constraint: array
        if ('' !== ($denominationArrayErrorMessage = self::validateDenominationForArrayConstraintsFromSetDenomination($denomination))) {
            throw new \InvalidArgumentException($denominationArrayErrorMessage, __LINE__);
        }
        if (is_null($denomination) || (is_array($denomination) && empty($denomination))) {
            unset($this->denomination);
        } else {
            $this->denomination = $denomination;
        }
        return $this;
    }
    /**
     * Add item to denomination value
     * @throws \InvalidArgumentException
     * @param \StructType\Denomination $item
     * @return \StructType\Airtime
     */
    public function addToDenomination(\StructType\Denomination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Denomination) {
            throw new \InvalidArgumentException(sprintf('The denomination property can only contain items of type \StructType\Denomination, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->denomination[] = $item;
        return $this;
    }
    /**
     * Get free_range_values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FreeRange|null
     */
    public function getFree_range_values()
    {
        return isset($this->free_range_values) ? $this->free_range_values : null;
    }
    /**
     * Set free_range_values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FreeRange $free_range_values
     * @return \StructType\Airtime
     */
    public function setFree_range_values(\StructType\FreeRange $free_range_values = null)
    {
        if (is_null($free_range_values) || (is_array($free_range_values) && empty($free_range_values))) {
            unset($this->free_range_values);
        } else {
            $this->free_range_values = $free_range_values;
        }
        return $this;
    }
    /**
     * Get receive_currency_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceive_currency_code()
    {
        return isset($this->receive_currency_code) ? $this->receive_currency_code : null;
    }
    /**
     * Set receive_currency_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receive_currency_code
     * @return \StructType\Airtime
     */
    public function setReceive_currency_code($receive_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($receive_currency_code) && !is_string($receive_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receive_currency_code, true), gettype($receive_currency_code)), __LINE__);
        }
        if (is_null($receive_currency_code) || (is_array($receive_currency_code) && empty($receive_currency_code))) {
            unset($this->receive_currency_code);
        } else {
            $this->receive_currency_code = $receive_currency_code;
        }
        return $this;
    }
}
