<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for validate_bank_account StructType
 * @subpackage Structs
 */
class Validate_bank_account extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credential
     */
    public $login;
    /**
     * The payee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Payee
     */
    public $payee;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Account
     */
    public $account;
    /**
     * The to_country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $to_country;
    /**
     * Constructor method for validate_bank_account
     * @uses Validate_bank_account::setLogin()
     * @uses Validate_bank_account::setPayee()
     * @uses Validate_bank_account::setAccount()
     * @uses Validate_bank_account::setTo_country()
     * @param \StructType\Credential $login
     * @param \StructType\Payee $payee
     * @param \StructType\Account $account
     * @param string $to_country
     */
    public function __construct(\StructType\Credential $login = null, \StructType\Payee $payee = null, \StructType\Account $account = null, $to_country = null)
    {
        $this
            ->setLogin($login)
            ->setPayee($payee)
            ->setAccount($account)
            ->setTo_country($to_country);
    }
    /**
     * Get login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credential|null
     */
    public function getLogin()
    {
        return isset($this->login) ? $this->login : null;
    }
    /**
     * Set login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credential $login
     * @return \StructType\Validate_bank_account
     */
    public function setLogin(\StructType\Credential $login = null)
    {
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->login);
        } else {
            $this->login = $login;
        }
        return $this;
    }
    /**
     * Get payee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Payee|null
     */
    public function getPayee()
    {
        return isset($this->payee) ? $this->payee : null;
    }
    /**
     * Set payee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Payee $payee
     * @return \StructType\Validate_bank_account
     */
    public function setPayee(\StructType\Payee $payee = null)
    {
        if (is_null($payee) || (is_array($payee) && empty($payee))) {
            unset($this->payee);
        } else {
            $this->payee = $payee;
        }
        return $this;
    }
    /**
     * Get account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Account|null
     */
    public function getAccount()
    {
        return isset($this->account) ? $this->account : null;
    }
    /**
     * Set account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Account $account
     * @return \StructType\Validate_bank_account
     */
    public function setAccount(\StructType\Account $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->account);
        } else {
            $this->account = $account;
        }
        return $this;
    }
    /**
     * Get to_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTo_country()
    {
        return isset($this->to_country) ? $this->to_country : null;
    }
    /**
     * Set to_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $to_country
     * @return \StructType\Validate_bank_account
     */
    public function setTo_country($to_country = null)
    {
        // validation for constraint: string
        if (!is_null($to_country) && !is_string($to_country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to_country, true), gettype($to_country)), __LINE__);
        }
        if (is_null($to_country) || (is_array($to_country) && empty($to_country))) {
            unset($this->to_country);
        } else {
            $this->to_country = $to_country;
        }
        return $this;
    }
}
