<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credential StructType
 * @subpackage Structs
 */
class Credential extends AbstractStructBase
{
    /**
     * The corporate_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $corporate_code;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * Constructor method for Credential
     * @uses Credential::setCorporate_code()
     * @uses Credential::setPassword()
     * @param string $corporate_code
     * @param string $password
     */
    public function __construct($corporate_code = null, $password = null)
    {
        $this
            ->setCorporate_code($corporate_code)
            ->setPassword($password);
    }
    /**
     * Get corporate_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCorporate_code()
    {
        return isset($this->corporate_code) ? $this->corporate_code : null;
    }
    /**
     * Set corporate_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $corporate_code
     * @return \StructType\Credential
     */
    public function setCorporate_code($corporate_code = null)
    {
        // validation for constraint: string
        if (!is_null($corporate_code) && !is_string($corporate_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporate_code, true), gettype($corporate_code)), __LINE__);
        }
        if (is_null($corporate_code) || (is_array($corporate_code) && empty($corporate_code))) {
            unset($this->corporate_code);
        } else {
            $this->corporate_code = $corporate_code;
        }
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\Credential
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
}
