<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Pixelboxx\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \Pixelboxx\ServiceType\Get($options);
/**
 * Sample call for getObject operation/method
 */
if ($get->getObject(new \Pixelboxx\StructType\GetObjectRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUsageList operation/method
 */
if ($get->getUsageList(new \Pixelboxx\StructType\GetUsageListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFolderStructure operation/method
 */
if ($get->getFolderStructure(new \Pixelboxx\StructType\GetFolderStructureRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFolder operation/method
 */
if ($get->getFolder(new \Pixelboxx\StructType\GetFolderRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTypeInfo operation/method
 */
if ($get->getTypeInfo(new \Pixelboxx\StructType\GetTypeInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \Pixelboxx\ServiceType\Delete($options);
/**
 * Sample call for deleteFolder operation/method
 */
if ($delete->deleteFolder(new \Pixelboxx\StructType\DeleteFolderRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteObject operation/method
 */
if ($delete->deleteObject(new \Pixelboxx\StructType\DeleteObjectRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \Pixelboxx\ServiceType\Move($options);
/**
 * Sample call for moveObject operation/method
 */
if ($move->moveObject(new \Pixelboxx\StructType\MoveObjectRequestType()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Rename ServiceType
 */
$rename = new \Pixelboxx\ServiceType\Rename($options);
/**
 * Sample call for renameFolder operation/method
 */
if ($rename->renameFolder(new \Pixelboxx\StructType\RenameFolderRequest()) !== false) {
    print_r($rename->getResult());
} else {
    print_r($rename->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \Pixelboxx\ServiceType\Import($options);
/**
 * Sample call for importFile operation/method
 */
if ($import->importFile(new \Pixelboxx\StructType\ImportFileRequest()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for importFileNewVersion operation/method
 */
if ($import->importFileNewVersion(new \Pixelboxx\StructType\ImportFileNewVersionRequest()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \Pixelboxx\ServiceType\Update($options);
/**
 * Sample call for updateObject operation/method
 */
if ($update->updateObject(new \Pixelboxx\StructType\UpdateObjectRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateUsageList operation/method
 */
if ($update->updateUsageList(new \Pixelboxx\StructType\UpdateUsageListRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \Pixelboxx\ServiceType\Create($options);
/**
 * Sample call for createObject operation/method
 */
if ($create->createObject(new \Pixelboxx\StructType\CreateObjectRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createFolder operation/method
 */
if ($create->createFolder(new \Pixelboxx\StructType\CreateFolderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \Pixelboxx\ServiceType\Search($options);
/**
 * Sample call for search operation/method
 */
if ($search->search(new \Pixelboxx\StructType\SearchRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \Pixelboxx\ServiceType\Remove($options);
/**
 * Sample call for removeObjectFromFolder operation/method
 */
if ($remove->removeObjectFromFolder(new \Pixelboxx\StructType\RemoveObjectFromFolderRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Extended ServiceType
 */
$extended = new \Pixelboxx\ServiceType\Extended($options);
/**
 * Sample call for extendedSearch operation/method
 */
if ($extended->extendedSearch(new \Pixelboxx\StructType\ExtendedSearchParamType()) !== false) {
    print_r($extended->getResult());
} else {
    print_r($extended->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \Pixelboxx\ServiceType\Add($options);
/**
 * Sample call for addObjectToFolder operation/method
 */
if ($add->addObjectToFolder(new \Pixelboxx\StructType\AddObjectToFolderRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
