<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsageListResultType StructType
 * Meta information extracted from the WSDL
 * - documentation: A single usage list entry, which will be returned as a list during the "getUsageList" request.
 * @subpackage Structs
 */
class UsageListResultType extends AbstractStructBase
{
    /**
     * The usageInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Pixelboxx\StructType\UsageInfoResultType
     */
    public $usageInfo;
    /**
     * The medium
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $medium;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $id;
    /**
     * The creationDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $creationDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The creationSystem
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $creationSystem;
    /**
     * The identifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identifier;
    /**
     * The contactMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contactMail;
    /**
     * The callbackUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callbackUrl;
    /**
     * The extendedUsageInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $extendedUsageInfo;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for UsageListResultType
     * @uses UsageListResultType::setUsageInfo()
     * @uses UsageListResultType::setMedium()
     * @uses UsageListResultType::setId()
     * @uses UsageListResultType::setCreationDate()
     * @uses UsageListResultType::setLastModifiedDate()
     * @uses UsageListResultType::setCreationSystem()
     * @uses UsageListResultType::setIdentifier()
     * @uses UsageListResultType::setContactMail()
     * @uses UsageListResultType::setCallbackUrl()
     * @uses UsageListResultType::setExtendedUsageInfo()
     * @uses UsageListResultType::setEndDate()
     * @param \Pixelboxx\StructType\UsageInfoResultType $usageInfo
     * @param string $medium
     * @param int $id
     * @param string $creationDate
     * @param string $lastModifiedDate
     * @param string $creationSystem
     * @param string $identifier
     * @param string $contactMail
     * @param string $callbackUrl
     * @param string $extendedUsageInfo
     * @param string $endDate
     */
    public function __construct(\Pixelboxx\StructType\UsageInfoResultType $usageInfo = null, $medium = null, $id = null, $creationDate = null, $lastModifiedDate = null, $creationSystem = null, $identifier = null, $contactMail = null, $callbackUrl = null, $extendedUsageInfo = null, $endDate = null)
    {
        $this
            ->setUsageInfo($usageInfo)
            ->setMedium($medium)
            ->setId($id)
            ->setCreationDate($creationDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCreationSystem($creationSystem)
            ->setIdentifier($identifier)
            ->setContactMail($contactMail)
            ->setCallbackUrl($callbackUrl)
            ->setExtendedUsageInfo($extendedUsageInfo)
            ->setEndDate($endDate);
    }
    /**
     * Get usageInfo value
     * @return \Pixelboxx\StructType\UsageInfoResultType
     */
    public function getUsageInfo()
    {
        return $this->usageInfo;
    }
    /**
     * Set usageInfo value
     * @param \Pixelboxx\StructType\UsageInfoResultType $usageInfo
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setUsageInfo(\Pixelboxx\StructType\UsageInfoResultType $usageInfo = null)
    {
        $this->usageInfo = $usageInfo;
        return $this;
    }
    /**
     * Get medium value
     * @return string
     */
    public function getMedium()
    {
        return $this->medium;
    }
    /**
     * Set medium value
     * @uses \Pixelboxx\EnumType\MediumType::valueIsValid()
     * @uses \Pixelboxx\EnumType\MediumType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $medium
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setMedium($medium = null)
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\MediumType::valueIsValid($medium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\MediumType', is_array($medium) ? implode(', ', $medium) : var_export($medium, true), implode(', ', \Pixelboxx\EnumType\MediumType::getValidValues())), __LINE__);
        }
        $this->medium = $medium;
        return $this;
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get creationSystem value
     * @return string
     */
    public function getCreationSystem()
    {
        return $this->creationSystem;
    }
    /**
     * Set creationSystem value
     * @param string $creationSystem
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setCreationSystem($creationSystem = null)
    {
        // validation for constraint: string
        if (!is_null($creationSystem) && !is_string($creationSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationSystem, true), gettype($creationSystem)), __LINE__);
        }
        $this->creationSystem = $creationSystem;
        return $this;
    }
    /**
     * Get identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param string $identifier
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get contactMail value
     * @return string|null
     */
    public function getContactMail()
    {
        return $this->contactMail;
    }
    /**
     * Set contactMail value
     * @param string $contactMail
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setContactMail($contactMail = null)
    {
        // validation for constraint: string
        if (!is_null($contactMail) && !is_string($contactMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactMail, true), gettype($contactMail)), __LINE__);
        }
        $this->contactMail = $contactMail;
        return $this;
    }
    /**
     * Get callbackUrl value
     * @return string|null
     */
    public function getCallbackUrl()
    {
        return $this->callbackUrl;
    }
    /**
     * Set callbackUrl value
     * @param string $callbackUrl
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setCallbackUrl($callbackUrl = null)
    {
        // validation for constraint: string
        if (!is_null($callbackUrl) && !is_string($callbackUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callbackUrl, true), gettype($callbackUrl)), __LINE__);
        }
        $this->callbackUrl = $callbackUrl;
        return $this;
    }
    /**
     * Get extendedUsageInfo value
     * @return string|null
     */
    public function getExtendedUsageInfo()
    {
        return $this->extendedUsageInfo;
    }
    /**
     * Set extendedUsageInfo value
     * @param string $extendedUsageInfo
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setExtendedUsageInfo($extendedUsageInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extendedUsageInfo) && !is_string($extendedUsageInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedUsageInfo, true), gettype($extendedUsageInfo)), __LINE__);
        }
        $this->extendedUsageInfo = $extendedUsageInfo;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \Pixelboxx\StructType\UsageListResultType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
}
