<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUsageListRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Bulk update of usage list entries of the object "ObjectId". Remarks: The total batch update size for a single request may be limited by the servers configuration!
 * @subpackage Structs
 */
class UpdateUsageListRequest extends AbstractStructBase
{
    /**
     * The ObjectId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \S+
     * @var string
     */
    public $ObjectId;
    /**
     * The creationSystem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $creationSystem;
    /**
     * The UsageListEntryType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: pb:UsageListEntryType
     * @var \Pixelboxx\StructType\UsageListEntryType[]
     */
    public $UsageListEntryType;
    /**
     * Constructor method for UpdateUsageListRequest
     * @uses UpdateUsageListRequest::setObjectId()
     * @uses UpdateUsageListRequest::setCreationSystem()
     * @uses UpdateUsageListRequest::setUsageListEntryType()
     * @param string $objectId
     * @param string $creationSystem
     * @param \Pixelboxx\StructType\UsageListEntryType[] $usageListEntryType
     */
    public function __construct($objectId = null, $creationSystem = null, array $usageListEntryType = array())
    {
        $this
            ->setObjectId($objectId)
            ->setCreationSystem($creationSystem)
            ->setUsageListEntryType($usageListEntryType);
    }
    /**
     * Get ObjectId value
     * @return string
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \Pixelboxx\StructType\UpdateUsageListRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($objectId) && !preg_match('/\\S+/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($objectId, true)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get creationSystem value
     * @return string
     */
    public function getCreationSystem()
    {
        return $this->creationSystem;
    }
    /**
     * Set creationSystem value
     * @param string $creationSystem
     * @return \Pixelboxx\StructType\UpdateUsageListRequest
     */
    public function setCreationSystem($creationSystem = null)
    {
        // validation for constraint: string
        if (!is_null($creationSystem) && !is_string($creationSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationSystem, true), gettype($creationSystem)), __LINE__);
        }
        $this->creationSystem = $creationSystem;
        return $this;
    }
    /**
     * Get UsageListEntryType value
     * @return \Pixelboxx\StructType\UsageListEntryType[]
     */
    public function getUsageListEntryType()
    {
        return $this->UsageListEntryType;
    }
    /**
     * This method is responsible for validating the values passed to the setUsageListEntryType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsageListEntryType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsageListEntryTypeForArrayConstraintsFromSetUsageListEntryType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateUsageListRequestUsageListEntryTypeItem) {
            // validation for constraint: itemType
            if (!$updateUsageListRequestUsageListEntryTypeItem instanceof \Pixelboxx\StructType\UsageListEntryType) {
                $invalidValues[] = is_object($updateUsageListRequestUsageListEntryTypeItem) ? get_class($updateUsageListRequestUsageListEntryTypeItem) : sprintf('%s(%s)', gettype($updateUsageListRequestUsageListEntryTypeItem), var_export($updateUsageListRequestUsageListEntryTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UsageListEntryType property can only contain items of type \Pixelboxx\StructType\UsageListEntryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UsageListEntryType value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\UsageListEntryType[] $usageListEntryType
     * @return \Pixelboxx\StructType\UpdateUsageListRequest
     */
    public function setUsageListEntryType(array $usageListEntryType = array())
    {
        // validation for constraint: array
        if ('' !== ($usageListEntryTypeArrayErrorMessage = self::validateUsageListEntryTypeForArrayConstraintsFromSetUsageListEntryType($usageListEntryType))) {
            throw new \InvalidArgumentException($usageListEntryTypeArrayErrorMessage, __LINE__);
        }
        $this->UsageListEntryType = $usageListEntryType;
        return $this;
    }
    /**
     * Add item to UsageListEntryType value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\UsageListEntryType $item
     * @return \Pixelboxx\StructType\UpdateUsageListRequest
     */
    public function addToUsageListEntryType(\Pixelboxx\StructType\UsageListEntryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\UsageListEntryType) {
            throw new \InvalidArgumentException(sprintf('The UsageListEntryType property can only contain items of type \Pixelboxx\StructType\UsageListEntryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UsageListEntryType[] = $item;
        return $this;
    }
}
