<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleSearchParamType StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine einfache Suchanfrage. Wesentlicher Bestandteil ist der Suchtext, aus dem die Suchanfrage je nach ParserPolicy generiert wird. Üblicherweise wird der Text in einzelne Worte zerlegt, nach denen AND-verknüpft gesucht wird. Es
 * sind mindestens die ParserPolicies "AND" und "OR" definiert, ist keine ParserPolicy angegeben so wird "AND" angenommen.
 * @subpackage Structs
 */
class SimpleSearchParamType extends AbstractStructBase
{
    /**
     * The SearchParams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\CommonSearchParamType
     */
    public $SearchParams;
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * The ParserPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParserPolicy;
    /**
     * Constructor method for SimpleSearchParamType
     * @uses SimpleSearchParamType::setSearchParams()
     * @uses SimpleSearchParamType::setText()
     * @uses SimpleSearchParamType::setParserPolicy()
     * @param \Pixelboxx\StructType\CommonSearchParamType $searchParams
     * @param string $text
     * @param string $parserPolicy
     */
    public function __construct(\Pixelboxx\StructType\CommonSearchParamType $searchParams = null, $text = null, $parserPolicy = null)
    {
        $this
            ->setSearchParams($searchParams)
            ->setText($text)
            ->setParserPolicy($parserPolicy);
    }
    /**
     * Get SearchParams value
     * @return \Pixelboxx\StructType\CommonSearchParamType|null
     */
    public function getSearchParams()
    {
        return $this->SearchParams;
    }
    /**
     * Set SearchParams value
     * @param \Pixelboxx\StructType\CommonSearchParamType $searchParams
     * @return \Pixelboxx\StructType\SimpleSearchParamType
     */
    public function setSearchParams(\Pixelboxx\StructType\CommonSearchParamType $searchParams = null)
    {
        $this->SearchParams = $searchParams;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Pixelboxx\StructType\SimpleSearchParamType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get ParserPolicy value
     * @return string|null
     */
    public function getParserPolicy()
    {
        return $this->ParserPolicy;
    }
    /**
     * Set ParserPolicy value
     * @param string $parserPolicy
     * @return \Pixelboxx\StructType\SimpleSearchParamType
     */
    public function setParserPolicy($parserPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($parserPolicy) && !is_string($parserPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parserPolicy, true), gettype($parserPolicy)), __LINE__);
        }
        $this->ParserPolicy = $parserPolicy;
        return $this;
    }
}
