<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchResultContentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Content of a search response (the result items). (Similar to FolderType, but without the folder-specific attributes.) "size" is the total number of matching elements, not just the returned range.
 * @subpackage Structs
 */
class SearchResultContentType extends AbstractStructBase
{
    /**
     * The Range
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\RangeType
     */
    public $Range;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\Content
     */
    public $Content;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - default: 0
     * - use: optional
     * @var int
     */
    public $size;
    /**
     * Constructor method for SearchResultContentType
     * @uses SearchResultContentType::setRange()
     * @uses SearchResultContentType::setContent()
     * @uses SearchResultContentType::setSize()
     * @param \Pixelboxx\StructType\RangeType $range
     * @param \Pixelboxx\StructType\Content $content
     * @param int $size
     */
    public function __construct(\Pixelboxx\StructType\RangeType $range = null, \Pixelboxx\StructType\Content $content = null, $size = '0')
    {
        $this
            ->setRange($range)
            ->setContent($content)
            ->setSize($size);
    }
    /**
     * Get Range value
     * @return \Pixelboxx\StructType\RangeType|null
     */
    public function getRange()
    {
        return $this->Range;
    }
    /**
     * Set Range value
     * @param \Pixelboxx\StructType\RangeType $range
     * @return \Pixelboxx\StructType\SearchResultContentType
     */
    public function setRange(\Pixelboxx\StructType\RangeType $range = null)
    {
        $this->Range = $range;
        return $this;
    }
    /**
     * Get Content value
     * @return \Pixelboxx\StructType\Content|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param \Pixelboxx\StructType\Content $content
     * @return \Pixelboxx\StructType\SearchResultContentType
     */
    public function setContent(\Pixelboxx\StructType\Content $content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \Pixelboxx\StructType\SearchResultContentType
     */
    public function setSize($size = '0')
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
}
