<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchAttributeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Suche nach einem Attribut. Dabei ist "name" der Attributname, "op" der Suchoperator und der Elementwert der Wert, mit dem verglichen werden soll. Der Attributwert steht links vom Operator, der Vergleichswert rechts davon. "langs"
 * darf eine Komma-separierte Liste von Sprachen oder "*" sein, ist dies angegeben erfolgt die Suche über die angegebenen bzw. alle Sprachen, ansonsten über die default-Sprache.
 * @subpackage Structs
 */
class SearchAttributeType extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The ref
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ref;
    /**
     * The op
     * Meta information extracted from the WSDL
     * - default: eq
     * - use: optional
     * @var string
     */
    public $op;
    /**
     * The langs
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $langs;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * Constructor method for SearchAttributeType
     * @uses SearchAttributeType::setName()
     * @uses SearchAttributeType::set_()
     * @uses SearchAttributeType::setRef()
     * @uses SearchAttributeType::setOp()
     * @uses SearchAttributeType::setLangs()
     * @uses SearchAttributeType::setType()
     * @param string $name
     * @param string $_
     * @param string $ref
     * @param string $op
     * @param string $langs
     * @param string $type
     */
    public function __construct($name = null, $_ = null, $ref = null, $op = 'eq', $langs = null, $type = null)
    {
        $this
            ->setName($name)
            ->set_($_)
            ->setRef($ref)
            ->setOp($op)
            ->setLangs($langs)
            ->setType($type);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Pixelboxx\StructType\SearchAttributeType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Pixelboxx\StructType\SearchAttributeType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ref value
     * @return string|null
     */
    public function getRef()
    {
        return $this->ref;
    }
    /**
     * Set ref value
     * @param string $ref
     * @return \Pixelboxx\StructType\SearchAttributeType
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        $this->ref = $ref;
        return $this;
    }
    /**
     * Get op value
     * @return string|null
     */
    public function getOp()
    {
        return $this->op;
    }
    /**
     * Set op value
     * @uses \Pixelboxx\EnumType\SearchOpType::valueIsValid()
     * @uses \Pixelboxx\EnumType\SearchOpType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $op
     * @return \Pixelboxx\StructType\SearchAttributeType
     */
    public function setOp($op = 'eq')
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\SearchOpType::valueIsValid($op)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\SearchOpType', is_array($op) ? implode(', ', $op) : var_export($op, true), implode(', ', \Pixelboxx\EnumType\SearchOpType::getValidValues())), __LINE__);
        }
        $this->op = $op;
        return $this;
    }
    /**
     * Get langs value
     * @return string|null
     */
    public function getLangs()
    {
        return $this->langs;
    }
    /**
     * Set langs value
     * @param string $langs
     * @return \Pixelboxx\StructType\SearchAttributeType
     */
    public function setLangs($langs = null)
    {
        // validation for constraint: string
        if (!is_null($langs) && !is_string($langs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langs, true), gettype($langs)), __LINE__);
        }
        $this->langs = $langs;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Pixelboxx\StructType\SearchAttributeType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
