<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RawDataRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Anforderung daran, welche Rohdaten wie geliefert werden sollen. Ausgeliefert werden können die unveränderten Feindaten (type="fine"), vorskalierte Ansichten als JPG in zwei verschiedenen größen ("layout" und "thumbnail"), sowie
 * ein selbstdefiniertes Format ("custom"), das durch "Conversion" und "Skaling" näher spezifiziert werden kann. Mit "location" wird festgelegt, wie die Ausgabe der Rohdaten erfolgen soll. Möglich sind "attach" (wird als Attachment hinzugefügt),
 * "url" (es wird eine Url geliefert, an der die Daten abrufbar sind), "writeto" (Daten werden an definierter Stelle im Filesystem abgelegt) und "include" (Daten werden direkt an Ort und Stelle als binär-Block eingefügt). In der ersten Version sind
 * als type nur "fine", "layout", "thumb und als location nur "include" und "url" implementiert. Ist mandatory true, so führt es zu einem Fehler, wenn die angeforderten Daten nicht existieren, ansonsten fehlen sie in der Antwort (default).
 * @subpackage Structs
 */
class RawDataRequestType extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The Conversion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ConversionType
     */
    public $Conversion;
    /**
     * The Scaling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ScalingType
     */
    public $Scaling;
    /**
     * The ImageProcessorParams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ImageProcessorParamsType
     */
    public $ImageProcessorParams;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - default: include
     * - use: optional
     * @var string
     */
    public $location;
    /**
     * The mandatory
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $mandatory;
    /**
     * Constructor method for RawDataRequestType
     * @uses RawDataRequestType::setType()
     * @uses RawDataRequestType::setConversion()
     * @uses RawDataRequestType::setScaling()
     * @uses RawDataRequestType::setImageProcessorParams()
     * @uses RawDataRequestType::setLocation()
     * @uses RawDataRequestType::setMandatory()
     * @param string $type
     * @param \Pixelboxx\StructType\ConversionType $conversion
     * @param \Pixelboxx\StructType\ScalingType $scaling
     * @param \Pixelboxx\StructType\ImageProcessorParamsType $imageProcessorParams
     * @param string $location
     * @param bool $mandatory
     */
    public function __construct($type = null, \Pixelboxx\StructType\ConversionType $conversion = null, \Pixelboxx\StructType\ScalingType $scaling = null, \Pixelboxx\StructType\ImageProcessorParamsType $imageProcessorParams = null, $location = 'include', $mandatory = false)
    {
        $this
            ->setType($type)
            ->setConversion($conversion)
            ->setScaling($scaling)
            ->setImageProcessorParams($imageProcessorParams)
            ->setLocation($location)
            ->setMandatory($mandatory);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \Pixelboxx\EnumType\RDType::valueIsValid()
     * @uses \Pixelboxx\EnumType\RDType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pixelboxx\StructType\RawDataRequestType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\RDType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\RDType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Pixelboxx\EnumType\RDType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get Conversion value
     * @return \Pixelboxx\StructType\ConversionType|null
     */
    public function getConversion()
    {
        return $this->Conversion;
    }
    /**
     * Set Conversion value
     * @param \Pixelboxx\StructType\ConversionType $conversion
     * @return \Pixelboxx\StructType\RawDataRequestType
     */
    public function setConversion(\Pixelboxx\StructType\ConversionType $conversion = null)
    {
        $this->Conversion = $conversion;
        return $this;
    }
    /**
     * Get Scaling value
     * @return \Pixelboxx\StructType\ScalingType|null
     */
    public function getScaling()
    {
        return $this->Scaling;
    }
    /**
     * Set Scaling value
     * @param \Pixelboxx\StructType\ScalingType $scaling
     * @return \Pixelboxx\StructType\RawDataRequestType
     */
    public function setScaling(\Pixelboxx\StructType\ScalingType $scaling = null)
    {
        $this->Scaling = $scaling;
        return $this;
    }
    /**
     * Get ImageProcessorParams value
     * @return \Pixelboxx\StructType\ImageProcessorParamsType|null
     */
    public function getImageProcessorParams()
    {
        return $this->ImageProcessorParams;
    }
    /**
     * Set ImageProcessorParams value
     * @param \Pixelboxx\StructType\ImageProcessorParamsType $imageProcessorParams
     * @return \Pixelboxx\StructType\RawDataRequestType
     */
    public function setImageProcessorParams(\Pixelboxx\StructType\ImageProcessorParamsType $imageProcessorParams = null)
    {
        $this->ImageProcessorParams = $imageProcessorParams;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @uses \Pixelboxx\EnumType\LocReqType::valueIsValid()
     * @uses \Pixelboxx\EnumType\LocReqType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $location
     * @return \Pixelboxx\StructType\RawDataRequestType
     */
    public function setLocation($location = 'include')
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\LocReqType::valueIsValid($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\LocReqType', is_array($location) ? implode(', ', $location) : var_export($location, true), implode(', ', \Pixelboxx\EnumType\LocReqType::getValidValues())), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get mandatory value
     * @return bool|null
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }
    /**
     * Set mandatory value
     * @param bool $mandatory
     * @return \Pixelboxx\StructType\RawDataRequestType
     */
    public function setMandatory($mandatory = false)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatory, true), gettype($mandatory)), __LINE__);
        }
        $this->mandatory = $mandatory;
        return $this;
    }
}
