<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RawDataLocationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Ort, an dem die Rohdaten zu finden sind. Attachment: Daten sind im Attachment mit der angegebenen Content-Id zu finden. URL: Daten sind an der angegebenen URL abzurufen. IncludedData: Daten sind direkt hier als base64Binary
 * eingeschlossen.
 * @subpackage Structs
 */
class RawDataLocationType extends AbstractStructBase
{
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - documentation: Typ für Content-Ids.
     * - base: xs:anyURI
     * - choice: Attachment | URL | IncludedData | AttachedData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: cid:.*
     * @var string
     */
    public $Attachment;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - choice: Attachment | URL | IncludedData | AttachedData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $URL;
    /**
     * The IncludedData
     * Meta information extracted from the WSDL
     * - choice: Attachment | URL | IncludedData | AttachedData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $IncludedData;
    /**
     * The AttachedData
     * Meta information extracted from the WSDL
     * - choice: Attachment | URL | IncludedData | AttachedData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - expectedContentTypes: application/octet-stream
     * @var string
     */
    public $AttachedData;
    /**
     * Constructor method for RawDataLocationType
     * @uses RawDataLocationType::setAttachment()
     * @uses RawDataLocationType::setURL()
     * @uses RawDataLocationType::setIncludedData()
     * @uses RawDataLocationType::setAttachedData()
     * @param string $attachment
     * @param string $uRL
     * @param string $includedData
     * @param string $attachedData
     */
    public function __construct($attachment = null, $uRL = null, $includedData = null, $attachedData = null)
    {
        $this
            ->setAttachment($attachment)
            ->setURL($uRL)
            ->setIncludedData($includedData)
            ->setAttachedData($attachedData);
    }
    /**
     * Get Attachment value
     * @return string|null
     */
    public function getAttachment()
    {
        return isset($this->Attachment) ? $this->Attachment : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAttachmentForChoiceConstraintsFromSetAttachment($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'URL',
            'IncludedData',
            'AttachedData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Attachment can\'t be set as the property %s is already set. Only one property must be set among these properties: Attachment, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Attachment value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $attachment
     * @return \Pixelboxx\StructType\RawDataLocationType
     */
    public function setAttachment($attachment = null)
    {
        // validation for constraint: string
        if (!is_null($attachment) && !is_string($attachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachment, true), gettype($attachment)), __LINE__);
        }
        // validation for constraint: choice(Attachment, URL, IncludedData, AttachedData)
        if ('' !== ($attachmentChoiceErrorMessage = self::validateAttachmentForChoiceConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(cid:.*)
        if (!is_null($attachment) && !preg_match('/cid:.*/', $attachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression cid:.*', var_export($attachment, true)), __LINE__);
        }
        if (is_null($attachment) || (is_array($attachment) && empty($attachment))) {
            unset($this->Attachment);
        } else {
            $this->Attachment = $attachment;
        }
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateURLForChoiceConstraintsFromSetURL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Attachment',
            'IncludedData',
            'AttachedData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property URL can\'t be set as the property %s is already set. Only one property must be set among these properties: URL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set URL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uRL
     * @return \Pixelboxx\StructType\RawDataLocationType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        // validation for constraint: choice(Attachment, URL, IncludedData, AttachedData)
        if ('' !== ($uRLChoiceErrorMessage = self::validateURLForChoiceConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLChoiceErrorMessage, __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
    /**
     * Get IncludedData value
     * @return string|null
     */
    public function getIncludedData()
    {
        return isset($this->IncludedData) ? $this->IncludedData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIncludedData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncludedData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIncludedDataForChoiceConstraintsFromSetIncludedData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Attachment',
            'URL',
            'AttachedData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property IncludedData can\'t be set as the property %s is already set. Only one property must be set among these properties: IncludedData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set IncludedData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $includedData
     * @return \Pixelboxx\StructType\RawDataLocationType
     */
    public function setIncludedData($includedData = null)
    {
        // validation for constraint: string
        if (!is_null($includedData) && !is_string($includedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includedData, true), gettype($includedData)), __LINE__);
        }
        // validation for constraint: choice(Attachment, URL, IncludedData, AttachedData)
        if ('' !== ($includedDataChoiceErrorMessage = self::validateIncludedDataForChoiceConstraintsFromSetIncludedData($includedData))) {
            throw new \InvalidArgumentException($includedDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($includedData) || (is_array($includedData) && empty($includedData))) {
            unset($this->IncludedData);
        } else {
            $this->IncludedData = $includedData;
        }
        return $this;
    }
    /**
     * Get AttachedData value
     * @return string|null
     */
    public function getAttachedData()
    {
        return isset($this->AttachedData) ? $this->AttachedData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAttachedData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachedData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAttachedDataForChoiceConstraintsFromSetAttachedData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Attachment',
            'URL',
            'IncludedData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AttachedData can\'t be set as the property %s is already set. Only one property must be set among these properties: AttachedData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AttachedData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $attachedData
     * @return \Pixelboxx\StructType\RawDataLocationType
     */
    public function setAttachedData($attachedData = null)
    {
        // validation for constraint: string
        if (!is_null($attachedData) && !is_string($attachedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachedData, true), gettype($attachedData)), __LINE__);
        }
        // validation for constraint: choice(Attachment, URL, IncludedData, AttachedData)
        if ('' !== ($attachedDataChoiceErrorMessage = self::validateAttachedDataForChoiceConstraintsFromSetAttachedData($attachedData))) {
            throw new \InvalidArgumentException($attachedDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($attachedData) || (is_array($attachedData) && empty($attachedData))) {
            unset($this->AttachedData);
        } else {
            $this->AttachedData = $attachedData;
        }
        return $this;
    }
}
