<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RawDataListRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Liste von Rohdatenanforderungen. Ist mandatory true, führen nicht vorhandene geforderte Daten zu einem Fehler, ansonsten fehlen sie nur in der Antwort (default). Der hier gesetzte Wert wird für jede einzelne Rohdatenanforderung
 * verwendet, wenn dort nichts anderes angegeben ist.
 * @subpackage Structs
 */
class RawDataListRequestType extends AbstractStructBase
{
    /**
     * The WantedRawData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Pixelboxx\StructType\RawDataRequestType[]
     */
    public $WantedRawData;
    /**
     * The mandatory
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $mandatory;
    /**
     * Constructor method for RawDataListRequestType
     * @uses RawDataListRequestType::setWantedRawData()
     * @uses RawDataListRequestType::setMandatory()
     * @param \Pixelboxx\StructType\RawDataRequestType[] $wantedRawData
     * @param bool $mandatory
     */
    public function __construct(array $wantedRawData = array(), $mandatory = false)
    {
        $this
            ->setWantedRawData($wantedRawData)
            ->setMandatory($mandatory);
    }
    /**
     * Get WantedRawData value
     * @return \Pixelboxx\StructType\RawDataRequestType[]
     */
    public function getWantedRawData()
    {
        return $this->WantedRawData;
    }
    /**
     * This method is responsible for validating the values passed to the setWantedRawData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWantedRawData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWantedRawDataForArrayConstraintsFromSetWantedRawData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rawDataListRequestTypeWantedRawDataItem) {
            // validation for constraint: itemType
            if (!$rawDataListRequestTypeWantedRawDataItem instanceof \Pixelboxx\StructType\RawDataRequestType) {
                $invalidValues[] = is_object($rawDataListRequestTypeWantedRawDataItem) ? get_class($rawDataListRequestTypeWantedRawDataItem) : sprintf('%s(%s)', gettype($rawDataListRequestTypeWantedRawDataItem), var_export($rawDataListRequestTypeWantedRawDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WantedRawData property can only contain items of type \Pixelboxx\StructType\RawDataRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WantedRawData value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\RawDataRequestType[] $wantedRawData
     * @return \Pixelboxx\StructType\RawDataListRequestType
     */
    public function setWantedRawData(array $wantedRawData = array())
    {
        // validation for constraint: array
        if ('' !== ($wantedRawDataArrayErrorMessage = self::validateWantedRawDataForArrayConstraintsFromSetWantedRawData($wantedRawData))) {
            throw new \InvalidArgumentException($wantedRawDataArrayErrorMessage, __LINE__);
        }
        $this->WantedRawData = $wantedRawData;
        return $this;
    }
    /**
     * Add item to WantedRawData value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\RawDataRequestType $item
     * @return \Pixelboxx\StructType\RawDataListRequestType
     */
    public function addToWantedRawData(\Pixelboxx\StructType\RawDataRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\RawDataRequestType) {
            throw new \InvalidArgumentException(sprintf('The WantedRawData property can only contain items of type \Pixelboxx\StructType\RawDataRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WantedRawData[] = $item;
        return $this;
    }
    /**
     * Get mandatory value
     * @return bool|null
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }
    /**
     * Set mandatory value
     * @param bool $mandatory
     * @return \Pixelboxx\StructType\RawDataListRequestType
     */
    public function setMandatory($mandatory = false)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatory, true), gettype($mandatory)), __LINE__);
        }
        $this->mandatory = $mandatory;
        return $this;
    }
}
