<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RangeFacetSpecType StructType
 * Meta information extracted from the WSDL
 * - documentation: Range facet specification for a range from "Min" (inclusive) to "Max" (inclusive). Min or Max may be unspecified, but not both.
 * @subpackage Structs
 */
class RangeFacetSpecType extends AbstractStructBase
{
    /**
     * The Min
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Min;
    /**
     * The Max
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Max;
    /**
     * Constructor method for RangeFacetSpecType
     * @uses RangeFacetSpecType::setMin()
     * @uses RangeFacetSpecType::setMax()
     * @param string $min
     * @param string $max
     */
    public function __construct($min = null, $max = null)
    {
        $this
            ->setMin($min)
            ->setMax($max);
    }
    /**
     * Get Min value
     * @return string|null
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param string $min
     * @return \Pixelboxx\StructType\RangeFacetSpecType
     */
    public function setMin($min = null)
    {
        // validation for constraint: string
        if (!is_null($min) && !is_string($min)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($min, true), gettype($min)), __LINE__);
        }
        $this->Min = $min;
        return $this;
    }
    /**
     * Get Max value
     * @return string|null
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param string $max
     * @return \Pixelboxx\StructType\RangeFacetSpecType
     */
    public function setMax($max = null)
    {
        // validation for constraint: string
        if (!is_null($max) && !is_string($max)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($max, true), gettype($max)), __LINE__);
        }
        $this->Max = $max;
        return $this;
    }
}
