<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveObjectRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Verschiebt das Objekt "ObjectId" aus der Mappe "FromFolderId" in die Mappe "ToFolderId". Der Aufruf ist simulierbar.
 * @subpackage Structs
 */
class MoveObjectRequestType extends AbstractStructBase
{
    /**
     * The FromFolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $FromFolderId;
    /**
     * The ToFolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $ToFolderId;
    /**
     * The ObjectId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $ObjectId;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * Constructor method for MoveObjectRequestType
     * @uses MoveObjectRequestType::setFromFolderId()
     * @uses MoveObjectRequestType::setToFolderId()
     * @uses MoveObjectRequestType::setObjectId()
     * @uses MoveObjectRequestType::setSimulate()
     * @param string $fromFolderId
     * @param string $toFolderId
     * @param string $objectId
     * @param bool $simulate
     */
    public function __construct($fromFolderId = null, $toFolderId = null, $objectId = null, $simulate = false)
    {
        $this
            ->setFromFolderId($fromFolderId)
            ->setToFolderId($toFolderId)
            ->setObjectId($objectId)
            ->setSimulate($simulate);
    }
    /**
     * Get FromFolderId value
     * @return string|null
     */
    public function getFromFolderId()
    {
        return $this->FromFolderId;
    }
    /**
     * Set FromFolderId value
     * @param string $fromFolderId
     * @return \Pixelboxx\StructType\MoveObjectRequestType
     */
    public function setFromFolderId($fromFolderId = null)
    {
        // validation for constraint: string
        if (!is_null($fromFolderId) && !is_string($fromFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromFolderId, true), gettype($fromFolderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($fromFolderId) && !preg_match('/\\S+/', $fromFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($fromFolderId, true)), __LINE__);
        }
        $this->FromFolderId = $fromFolderId;
        return $this;
    }
    /**
     * Get ToFolderId value
     * @return string|null
     */
    public function getToFolderId()
    {
        return $this->ToFolderId;
    }
    /**
     * Set ToFolderId value
     * @param string $toFolderId
     * @return \Pixelboxx\StructType\MoveObjectRequestType
     */
    public function setToFolderId($toFolderId = null)
    {
        // validation for constraint: string
        if (!is_null($toFolderId) && !is_string($toFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toFolderId, true), gettype($toFolderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($toFolderId) && !preg_match('/\\S+/', $toFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($toFolderId, true)), __LINE__);
        }
        $this->ToFolderId = $toFolderId;
        return $this;
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \Pixelboxx\StructType\MoveObjectRequestType
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($objectId) && !preg_match('/\\S+/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($objectId, true)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\MoveObjectRequestType
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
}
