<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetadataRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Anforderung von Metadaten. Spezifiziert, welche Metadaten bei einer Anfrage zurückgeliefert werden sollen. Dabei ist es möglich, keine Attribute ("none"), alle Attribute ("all"), eine Serverseitig vorkonfigurierte Liste der am
 * häufigsten benötigten Attribute ("basic") oder explizit vorgegebene bestimmte Attribute ("explicit") auszuliefern. Nur in letzterem Fall hat die mitgelieferte Liste der gewünschten Attribute Relevanz. Attribute können u.U. sprachabhängig
 * verschiedene Werte enthalten, mittels "Languages" lässt sich spezifizieren, wie die Ausgabe in diesem Fall zu erfolgen hat. "accesscontrol" gibt an, ob die Access-Control-Attribute mit ausgeliefert werden sollen. Ist mandatory true, so läst jedes
 * nicht vorhandene, explizit angeforderte Attribut einen Fehler aus (ansonsten fehlt das Attribut in der Antwort, default-Verhalten). Der hier angegebene Wert wird für jede einzelne Attributanforderung verwendet, wenn dort nichts anderes angegeben
 * ist.
 * @subpackage Structs
 */
class MetadataRequestType extends AbstractStructBase
{
    /**
     * The Languages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\LanguageRequestType
     */
    public $Languages;
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\AttributeReqType[]
     */
    public $Attribute;
    /**
     * The attributes
     * Meta information extracted from the WSDL
     * - default: none
     * - use: optional
     * @var string
     */
    public $attributes;
    /**
     * The accesscontrol
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $accesscontrol;
    /**
     * The mandatory
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $mandatory;
    /**
     * Constructor method for MetadataRequestType
     * @uses MetadataRequestType::setLanguages()
     * @uses MetadataRequestType::setAttribute()
     * @uses MetadataRequestType::setAttributes()
     * @uses MetadataRequestType::setAccesscontrol()
     * @uses MetadataRequestType::setMandatory()
     * @param \Pixelboxx\StructType\LanguageRequestType $languages
     * @param \Pixelboxx\StructType\AttributeReqType[] $attribute
     * @param string $attributes
     * @param bool $accesscontrol
     * @param bool $mandatory
     */
    public function __construct(\Pixelboxx\StructType\LanguageRequestType $languages = null, array $attribute = array(), $attributes = 'none', $accesscontrol = false, $mandatory = false)
    {
        $this
            ->setLanguages($languages)
            ->setAttribute($attribute)
            ->setAttributes($attributes)
            ->setAccesscontrol($accesscontrol)
            ->setMandatory($mandatory);
    }
    /**
     * Get Languages value
     * @return \Pixelboxx\StructType\LanguageRequestType|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \Pixelboxx\StructType\LanguageRequestType $languages
     * @return \Pixelboxx\StructType\MetadataRequestType
     */
    public function setLanguages(\Pixelboxx\StructType\LanguageRequestType $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Get Attribute value
     * @return \Pixelboxx\StructType\AttributeReqType[]|null
     */
    public function getAttribute()
    {
        return $this->Attribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $metadataRequestTypeAttributeItem) {
            // validation for constraint: itemType
            if (!$metadataRequestTypeAttributeItem instanceof \Pixelboxx\StructType\AttributeReqType) {
                $invalidValues[] = is_object($metadataRequestTypeAttributeItem) ? get_class($metadataRequestTypeAttributeItem) : sprintf('%s(%s)', gettype($metadataRequestTypeAttributeItem), var_export($metadataRequestTypeAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attribute property can only contain items of type \Pixelboxx\StructType\AttributeReqType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attribute value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\AttributeReqType[] $attribute
     * @return \Pixelboxx\StructType\MetadataRequestType
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        $this->Attribute = $attribute;
        return $this;
    }
    /**
     * Add item to Attribute value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\AttributeReqType $item
     * @return \Pixelboxx\StructType\MetadataRequestType
     */
    public function addToAttribute(\Pixelboxx\StructType\AttributeReqType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\AttributeReqType) {
            throw new \InvalidArgumentException(sprintf('The Attribute property can only contain items of type \Pixelboxx\StructType\AttributeReqType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attribute[] = $item;
        return $this;
    }
    /**
     * Get attributes value
     * @return string|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param string $attributes
     * @return \Pixelboxx\StructType\MetadataRequestType
     */
    public function setAttributes($attributes = 'none')
    {
        // validation for constraint: string
        if (!is_null($attributes) && !is_string($attributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributes, true), gettype($attributes)), __LINE__);
        }
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get accesscontrol value
     * @return bool|null
     */
    public function getAccesscontrol()
    {
        return $this->accesscontrol;
    }
    /**
     * Set accesscontrol value
     * @param bool $accesscontrol
     * @return \Pixelboxx\StructType\MetadataRequestType
     */
    public function setAccesscontrol($accesscontrol = false)
    {
        // validation for constraint: boolean
        if (!is_null($accesscontrol) && !is_bool($accesscontrol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accesscontrol, true), gettype($accesscontrol)), __LINE__);
        }
        $this->accesscontrol = $accesscontrol;
        return $this;
    }
    /**
     * Get mandatory value
     * @return bool|null
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }
    /**
     * Set mandatory value
     * @param bool $mandatory
     * @return \Pixelboxx\StructType\MetadataRequestType
     */
    public function setMandatory($mandatory = false)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatory, true), gettype($mandatory)), __LINE__);
        }
        $this->mandatory = $mandatory;
        return $this;
    }
}
