<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageProcessorParamsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Image processor parameters as described by chapter 'Image Operations in detail' of 'Intermedia Fotoficient - The First Book' (im-first_book.pdf). (http://intermedia.pixelboxx.com/svn/trunk/intermedia-fotoficient/doc/manuals; for
 * registration see http://intermedia.pixelboxx.com/) Please set attribute "type" of RawDataRequest to 'custom'.
 * @subpackage Structs
 */
class ImageProcessorParamsType extends AbstractStructBase
{
    /**
     * The ImageOp
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Pixelboxx\StructType\ImageOpType[]
     */
    public $ImageOp;
    /**
     * Constructor method for ImageProcessorParamsType
     * @uses ImageProcessorParamsType::setImageOp()
     * @param \Pixelboxx\StructType\ImageOpType[] $imageOp
     */
    public function __construct(array $imageOp = array())
    {
        $this
            ->setImageOp($imageOp);
    }
    /**
     * Get ImageOp value
     * @return \Pixelboxx\StructType\ImageOpType[]
     */
    public function getImageOp()
    {
        return $this->ImageOp;
    }
    /**
     * This method is responsible for validating the values passed to the setImageOp method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageOp method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageOpForArrayConstraintsFromSetImageOp(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imageProcessorParamsTypeImageOpItem) {
            // validation for constraint: itemType
            if (!$imageProcessorParamsTypeImageOpItem instanceof \Pixelboxx\StructType\ImageOpType) {
                $invalidValues[] = is_object($imageProcessorParamsTypeImageOpItem) ? get_class($imageProcessorParamsTypeImageOpItem) : sprintf('%s(%s)', gettype($imageProcessorParamsTypeImageOpItem), var_export($imageProcessorParamsTypeImageOpItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageOp property can only contain items of type \Pixelboxx\StructType\ImageOpType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageOp value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ImageOpType[] $imageOp
     * @return \Pixelboxx\StructType\ImageProcessorParamsType
     */
    public function setImageOp(array $imageOp = array())
    {
        // validation for constraint: array
        if ('' !== ($imageOpArrayErrorMessage = self::validateImageOpForArrayConstraintsFromSetImageOp($imageOp))) {
            throw new \InvalidArgumentException($imageOpArrayErrorMessage, __LINE__);
        }
        $this->ImageOp = $imageOp;
        return $this;
    }
    /**
     * Add item to ImageOp value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ImageOpType $item
     * @return \Pixelboxx\StructType\ImageProcessorParamsType
     */
    public function addToImageOp(\Pixelboxx\StructType\ImageOpType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\ImageOpType) {
            throw new \InvalidArgumentException(sprintf('The ImageOp property can only contain items of type \Pixelboxx\StructType\ImageOpType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageOp[] = $item;
        return $this;
    }
}
