<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageAttributesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Attribute für Bilder. Zwingend notwendig sind nur xsize und ysize.
 * @subpackage Structs
 */
class ImageAttributesType extends AbstractStructBase
{
    /**
     * The xsize
     * @var int
     */
    public $xsize;
    /**
     * The ysize
     * @var int
     */
    public $ysize;
    /**
     * Constructor method for ImageAttributesType
     * @uses ImageAttributesType::setXsize()
     * @uses ImageAttributesType::setYsize()
     * @param int $xsize
     * @param int $ysize
     */
    public function __construct($xsize = null, $ysize = null)
    {
        $this
            ->setXsize($xsize)
            ->setYsize($ysize);
    }
    /**
     * Get xsize value
     * @return int|null
     */
    public function getXsize()
    {
        return $this->xsize;
    }
    /**
     * Set xsize value
     * @param int $xsize
     * @return \Pixelboxx\StructType\ImageAttributesType
     */
    public function setXsize($xsize = null)
    {
        // validation for constraint: int
        if (!is_null($xsize) && !(is_int($xsize) || ctype_digit($xsize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($xsize, true), gettype($xsize)), __LINE__);
        }
        $this->xsize = $xsize;
        return $this;
    }
    /**
     * Get ysize value
     * @return int|null
     */
    public function getYsize()
    {
        return $this->ysize;
    }
    /**
     * Set ysize value
     * @param int $ysize
     * @return \Pixelboxx\StructType\ImageAttributesType
     */
    public function setYsize($ysize = null)
    {
        // validation for constraint: int
        if (!is_null($ysize) && !(is_int($ysize) || ctype_digit($ysize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ysize, true), gettype($ysize)), __LINE__);
        }
        $this->ysize = $ysize;
        return $this;
    }
}
