<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFolderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Abfrage des Inhalts der Mappe "FolderId". Mittels "Range" kann auch ein Teil der Mappe abgefragt werden (z.B. Objekte 50-99). Abfragen können mit Metadaten und/oder Rohdaten der Objekte erfolgen. Der Aufruf ist simulierbar (nur
 * Ergebnis, ob er erfolgreich wäre, ohne tatsächliche Änderung).
 * @subpackage Structs
 */
class GetFolderRequest extends AbstractStructBase
{
    /**
     * The FolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $FolderId;
    /**
     * The Range
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\RangeType
     */
    public $Range;
    /**
     * The WithMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\MetadataRequestType
     */
    public $WithMetadata;
    /**
     * The WithRawData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\RawDataListRequestType
     */
    public $WithRawData;
    /**
     * The DataSpec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\DataSpecificationType
     */
    public $DataSpec;
    /**
     * Constructor method for GetFolderRequest
     * @uses GetFolderRequest::setFolderId()
     * @uses GetFolderRequest::setRange()
     * @uses GetFolderRequest::setWithMetadata()
     * @uses GetFolderRequest::setWithRawData()
     * @uses GetFolderRequest::setDataSpec()
     * @param string $folderId
     * @param \Pixelboxx\StructType\RangeType $range
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @param \Pixelboxx\StructType\RawDataListRequestType $withRawData
     * @param \Pixelboxx\StructType\DataSpecificationType $dataSpec
     */
    public function __construct($folderId = null, \Pixelboxx\StructType\RangeType $range = null, \Pixelboxx\StructType\MetadataRequestType $withMetadata = null, \Pixelboxx\StructType\RawDataListRequestType $withRawData = null, \Pixelboxx\StructType\DataSpecificationType $dataSpec = null)
    {
        $this
            ->setFolderId($folderId)
            ->setRange($range)
            ->setWithMetadata($withMetadata)
            ->setWithRawData($withRawData)
            ->setDataSpec($dataSpec);
    }
    /**
     * Get FolderId value
     * @return string|null
     */
    public function getFolderId()
    {
        return $this->FolderId;
    }
    /**
     * Set FolderId value
     * @param string $folderId
     * @return \Pixelboxx\StructType\GetFolderRequest
     */
    public function setFolderId($folderId = null)
    {
        // validation for constraint: string
        if (!is_null($folderId) && !is_string($folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folderId, true), gettype($folderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($folderId) && !preg_match('/\\S+/', $folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($folderId, true)), __LINE__);
        }
        $this->FolderId = $folderId;
        return $this;
    }
    /**
     * Get Range value
     * @return \Pixelboxx\StructType\RangeType|null
     */
    public function getRange()
    {
        return $this->Range;
    }
    /**
     * Set Range value
     * @param \Pixelboxx\StructType\RangeType $range
     * @return \Pixelboxx\StructType\GetFolderRequest
     */
    public function setRange(\Pixelboxx\StructType\RangeType $range = null)
    {
        $this->Range = $range;
        return $this;
    }
    /**
     * Get WithMetadata value
     * @return \Pixelboxx\StructType\MetadataRequestType|null
     */
    public function getWithMetadata()
    {
        return $this->WithMetadata;
    }
    /**
     * Set WithMetadata value
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @return \Pixelboxx\StructType\GetFolderRequest
     */
    public function setWithMetadata(\Pixelboxx\StructType\MetadataRequestType $withMetadata = null)
    {
        $this->WithMetadata = $withMetadata;
        return $this;
    }
    /**
     * Get WithRawData value
     * @return \Pixelboxx\StructType\RawDataListRequestType|null
     */
    public function getWithRawData()
    {
        return $this->WithRawData;
    }
    /**
     * Set WithRawData value
     * @param \Pixelboxx\StructType\RawDataListRequestType $withRawData
     * @return \Pixelboxx\StructType\GetFolderRequest
     */
    public function setWithRawData(\Pixelboxx\StructType\RawDataListRequestType $withRawData = null)
    {
        $this->WithRawData = $withRawData;
        return $this;
    }
    /**
     * Get DataSpec value
     * @return \Pixelboxx\StructType\DataSpecificationType|null
     */
    public function getDataSpec()
    {
        return $this->DataSpec;
    }
    /**
     * Set DataSpec value
     * @param \Pixelboxx\StructType\DataSpecificationType $dataSpec
     * @return \Pixelboxx\StructType\GetFolderRequest
     */
    public function setDataSpec(\Pixelboxx\StructType\DataSpecificationType $dataSpec = null)
    {
        $this->DataSpec = $dataSpec;
        return $this;
    }
}
