<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FolderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Folder, kann mehrere Objekte oder Folder enthalten. Dabei gibt "size" die Anzahl der Inhaltselement an, die der Folder wirklich enthält, die Anzahl der zurückgelieferten Objekte kann geringer sein. Wenn ein Ausschnitt geliefert
 * wird, so gibt "Range" den tatsächlich gelieferten Ausschnitt an. Folder werden nicht rekursiv abgerufen, d.h. von den Foldern, die in einem Folder enthalten sind, wird nicht der Inhalt mitgeliefert.
 * @subpackage Structs
 */
class FolderType extends AbstractObjectType
{
    /**
     * The Range
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\RangeType
     */
    public $Range;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\Content
     */
    public $Content;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - default: 0
     * - use: optional
     * @var int
     */
    public $size;
    /**
     * Constructor method for FolderType
     * @uses FolderType::setRange()
     * @uses FolderType::setContent()
     * @uses FolderType::setSize()
     * @param \Pixelboxx\StructType\RangeType $range
     * @param \Pixelboxx\StructType\Content $content
     * @param int $size
     */
    public function __construct(\Pixelboxx\StructType\RangeType $range = null, \Pixelboxx\StructType\Content $content = null, $size = '0')
    {
        $this
            ->setRange($range)
            ->setContent($content)
            ->setSize($size);
    }
    /**
     * Get Range value
     * @return \Pixelboxx\StructType\RangeType|null
     */
    public function getRange()
    {
        return $this->Range;
    }
    /**
     * Set Range value
     * @param \Pixelboxx\StructType\RangeType $range
     * @return \Pixelboxx\StructType\FolderType
     */
    public function setRange(\Pixelboxx\StructType\RangeType $range = null)
    {
        $this->Range = $range;
        return $this;
    }
    /**
     * Get Content value
     * @return \Pixelboxx\StructType\Content|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param \Pixelboxx\StructType\Content $content
     * @return \Pixelboxx\StructType\FolderType
     */
    public function setContent(\Pixelboxx\StructType\Content $content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \Pixelboxx\StructType\FolderType
     */
    public function setSize($size = '0')
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
}
