<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacetSpecType StructType
 * Meta information extracted from the WSDL
 * - documentation: One of the possible specifications of a facet. If this element is empty (unspecified), all existing facets with this name (and count greater 0) will be returned. e.g. an empty specification with name="pb1core__type" will return a
 * facet group with values for each type and their respective count.
 * @subpackage Structs
 */
class FacetSpecType extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The MultiValue
     * Meta information extracted from the WSDL
     * - choice: MultiValue | Range
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \Pixelboxx\StructType\MultiValueFacetSpecType
     */
    public $MultiValue;
    /**
     * The Range
     * Meta information extracted from the WSDL
     * - choice: MultiValue | Range
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \Pixelboxx\StructType\RangeFacetSpecType
     */
    public $Range;
    /**
     * Constructor method for FacetSpecType
     * @uses FacetSpecType::setName()
     * @uses FacetSpecType::setMultiValue()
     * @uses FacetSpecType::setRange()
     * @param string $name
     * @param \Pixelboxx\StructType\MultiValueFacetSpecType $multiValue
     * @param \Pixelboxx\StructType\RangeFacetSpecType $range
     */
    public function __construct($name = null, \Pixelboxx\StructType\MultiValueFacetSpecType $multiValue = null, \Pixelboxx\StructType\RangeFacetSpecType $range = null)
    {
        $this
            ->setName($name)
            ->setMultiValue($multiValue)
            ->setRange($range);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Pixelboxx\StructType\FacetSpecType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get MultiValue value
     * @return \Pixelboxx\StructType\MultiValueFacetSpecType|null
     */
    public function getMultiValue()
    {
        return isset($this->MultiValue) ? $this->MultiValue : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMultiValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiValue method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMultiValueForChoiceConstraintsFromSetMultiValue($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Range',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MultiValue can\'t be set as the property %s is already set. Only one property must be set among these properties: MultiValue, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MultiValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\MultiValueFacetSpecType $multiValue
     * @return \Pixelboxx\StructType\FacetSpecType
     */
    public function setMultiValue(\Pixelboxx\StructType\MultiValueFacetSpecType $multiValue = null)
    {
        // validation for constraint: choice(MultiValue, Range)
        if ('' !== ($multiValueChoiceErrorMessage = self::validateMultiValueForChoiceConstraintsFromSetMultiValue($multiValue))) {
            throw new \InvalidArgumentException($multiValueChoiceErrorMessage, __LINE__);
        }
        if (is_null($multiValue) || (is_array($multiValue) && empty($multiValue))) {
            unset($this->MultiValue);
        } else {
            $this->MultiValue = $multiValue;
        }
        return $this;
    }
    /**
     * Get Range value
     * @return \Pixelboxx\StructType\RangeFacetSpecType|null
     */
    public function getRange()
    {
        return isset($this->Range) ? $this->Range : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRange method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRangeForChoiceConstraintsFromSetRange($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MultiValue',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Range can\'t be set as the property %s is already set. Only one property must be set among these properties: Range, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Range value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\RangeFacetSpecType $range
     * @return \Pixelboxx\StructType\FacetSpecType
     */
    public function setRange(\Pixelboxx\StructType\RangeFacetSpecType $range = null)
    {
        // validation for constraint: choice(MultiValue, Range)
        if ('' !== ($rangeChoiceErrorMessage = self::validateRangeForChoiceConstraintsFromSetRange($range))) {
            throw new \InvalidArgumentException($rangeChoiceErrorMessage, __LINE__);
        }
        if (is_null($range) || (is_array($range) && empty($range))) {
            unset($this->Range);
        } else {
            $this->Range = $range;
        }
        return $this;
    }
}
