<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacetGroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Group of facets for the same property, contains all matching facets with count greater 0. May contain Label for different languages (if LabelLanguages were requested), this is the label of the property itself.
 * @subpackage Structs
 */
class FacetGroupType extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\DisplayNameType[]
     */
    public $Label;
    /**
     * The Facet
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\FacetType[]
     */
    public $Facet;
    /**
     * Constructor method for FacetGroupType
     * @uses FacetGroupType::setName()
     * @uses FacetGroupType::setLabel()
     * @uses FacetGroupType::setFacet()
     * @param string $name
     * @param \Pixelboxx\StructType\DisplayNameType[] $label
     * @param \Pixelboxx\StructType\FacetType[] $facet
     */
    public function __construct($name = null, array $label = array(), array $facet = array())
    {
        $this
            ->setName($name)
            ->setLabel($label)
            ->setFacet($facet);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Pixelboxx\StructType\FacetGroupType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get Label value
     * @return \Pixelboxx\StructType\DisplayNameType[]|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * This method is responsible for validating the values passed to the setLabel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelForArrayConstraintsFromSetLabel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $facetGroupTypeLabelItem) {
            // validation for constraint: itemType
            if (!$facetGroupTypeLabelItem instanceof \Pixelboxx\StructType\DisplayNameType) {
                $invalidValues[] = is_object($facetGroupTypeLabelItem) ? get_class($facetGroupTypeLabelItem) : sprintf('%s(%s)', gettype($facetGroupTypeLabelItem), var_export($facetGroupTypeLabelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Label property can only contain items of type \Pixelboxx\StructType\DisplayNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Label value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayNameType[] $label
     * @return \Pixelboxx\StructType\FacetGroupType
     */
    public function setLabel(array $label = array())
    {
        // validation for constraint: array
        if ('' !== ($labelArrayErrorMessage = self::validateLabelForArrayConstraintsFromSetLabel($label))) {
            throw new \InvalidArgumentException($labelArrayErrorMessage, __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Add item to Label value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayNameType $item
     * @return \Pixelboxx\StructType\FacetGroupType
     */
    public function addToLabel(\Pixelboxx\StructType\DisplayNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\DisplayNameType) {
            throw new \InvalidArgumentException(sprintf('The Label property can only contain items of type \Pixelboxx\StructType\DisplayNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Label[] = $item;
        return $this;
    }
    /**
     * Get Facet value
     * @return \Pixelboxx\StructType\FacetType[]|null
     */
    public function getFacet()
    {
        return $this->Facet;
    }
    /**
     * This method is responsible for validating the values passed to the setFacet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFacet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFacetForArrayConstraintsFromSetFacet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $facetGroupTypeFacetItem) {
            // validation for constraint: itemType
            if (!$facetGroupTypeFacetItem instanceof \Pixelboxx\StructType\FacetType) {
                $invalidValues[] = is_object($facetGroupTypeFacetItem) ? get_class($facetGroupTypeFacetItem) : sprintf('%s(%s)', gettype($facetGroupTypeFacetItem), var_export($facetGroupTypeFacetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Facet property can only contain items of type \Pixelboxx\StructType\FacetType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Facet value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FacetType[] $facet
     * @return \Pixelboxx\StructType\FacetGroupType
     */
    public function setFacet(array $facet = array())
    {
        // validation for constraint: array
        if ('' !== ($facetArrayErrorMessage = self::validateFacetForArrayConstraintsFromSetFacet($facet))) {
            throw new \InvalidArgumentException($facetArrayErrorMessage, __LINE__);
        }
        $this->Facet = $facet;
        return $this;
    }
    /**
     * Add item to Facet value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FacetType $item
     * @return \Pixelboxx\StructType\FacetGroupType
     */
    public function addToFacet(\Pixelboxx\StructType\FacetType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\FacetType) {
            throw new \InvalidArgumentException(sprintf('The Facet property can only contain items of type \Pixelboxx\StructType\FacetType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Facet[] = $item;
        return $this;
    }
}
