<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisplayableAttributeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Attribut, das einen Display-Namen für jede Sprache für seine Werte haben kann
 * @subpackage Structs
 */
class DisplayableAttributeType extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $value;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\DisplayNameType[]
     */
    public $displayName;
    /**
     * Constructor method for DisplayableAttributeType
     * @uses DisplayableAttributeType::setName()
     * @uses DisplayableAttributeType::setValue()
     * @uses DisplayableAttributeType::setDisplayName()
     * @param string $name
     * @param string[] $value
     * @param \Pixelboxx\StructType\DisplayNameType[] $displayName
     */
    public function __construct($name = null, array $value = array(), array $displayName = array())
    {
        $this
            ->setName($name)
            ->setValue($value)
            ->setDisplayName($displayName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Pixelboxx\StructType\DisplayableAttributeType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get value value
     * @return string[]|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $displayableAttributeTypeValueItem) {
            // validation for constraint: itemType
            if (!is_string($displayableAttributeTypeValueItem)) {
                $invalidValues[] = is_object($displayableAttributeTypeValueItem) ? get_class($displayableAttributeTypeValueItem) : sprintf('%s(%s)', gettype($displayableAttributeTypeValueItem), var_export($displayableAttributeTypeValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The value property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param string[] $value
     * @return \Pixelboxx\StructType\DisplayableAttributeType
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pixelboxx\StructType\DisplayableAttributeType
     */
    public function addToValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
    /**
     * Get displayName value
     * @return \Pixelboxx\StructType\DisplayNameType[]|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * This method is responsible for validating the values passed to the setDisplayName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisplayName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisplayNameForArrayConstraintsFromSetDisplayName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $displayableAttributeTypeDisplayNameItem) {
            // validation for constraint: itemType
            if (!$displayableAttributeTypeDisplayNameItem instanceof \Pixelboxx\StructType\DisplayNameType) {
                $invalidValues[] = is_object($displayableAttributeTypeDisplayNameItem) ? get_class($displayableAttributeTypeDisplayNameItem) : sprintf('%s(%s)', gettype($displayableAttributeTypeDisplayNameItem), var_export($displayableAttributeTypeDisplayNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The displayName property can only contain items of type \Pixelboxx\StructType\DisplayNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set displayName value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayNameType[] $displayName
     * @return \Pixelboxx\StructType\DisplayableAttributeType
     */
    public function setDisplayName(array $displayName = array())
    {
        // validation for constraint: array
        if ('' !== ($displayNameArrayErrorMessage = self::validateDisplayNameForArrayConstraintsFromSetDisplayName($displayName))) {
            throw new \InvalidArgumentException($displayNameArrayErrorMessage, __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Add item to displayName value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayNameType $item
     * @return \Pixelboxx\StructType\DisplayableAttributeType
     */
    public function addToDisplayName(\Pixelboxx\StructType\DisplayNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\DisplayNameType) {
            throw new \InvalidArgumentException(sprintf('The displayName property can only contain items of type \Pixelboxx\StructType\DisplayNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->displayName[] = $item;
        return $this;
    }
}
