<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataSpecificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Spezifikation von angeforderten Daten zu einem Objekt/Mappe. idtype - ids als doi oder oid verwenden und zurückgeben subfolders - Bei Mappenabfragen Untermappen im Inhalt mit zurückliefern. parentfolders - Mappen, in denen sich das
 * Objekt befindet, zurückliefern.
 * @subpackage Structs
 */
class DataSpecificationType extends AbstractStructBase
{
    /**
     * The idtype
     * Meta information extracted from the WSDL
     * - default: doi
     * - use: optional
     * @var string
     */
    public $idtype;
    /**
     * The subfolders
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $subfolders;
    /**
     * The parentfolders
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $parentfolders;
    /**
     * Constructor method for DataSpecificationType
     * @uses DataSpecificationType::setIdtype()
     * @uses DataSpecificationType::setSubfolders()
     * @uses DataSpecificationType::setParentfolders()
     * @param string $idtype
     * @param bool $subfolders
     * @param bool $parentfolders
     */
    public function __construct($idtype = 'doi', $subfolders = false, $parentfolders = false)
    {
        $this
            ->setIdtype($idtype)
            ->setSubfolders($subfolders)
            ->setParentfolders($parentfolders);
    }
    /**
     * Get idtype value
     * @return string|null
     */
    public function getIdtype()
    {
        return $this->idtype;
    }
    /**
     * Set idtype value
     * @uses \Pixelboxx\EnumType\IDType::valueIsValid()
     * @uses \Pixelboxx\EnumType\IDType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idtype
     * @return \Pixelboxx\StructType\DataSpecificationType
     */
    public function setIdtype($idtype = 'doi')
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\IDType::valueIsValid($idtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\IDType', is_array($idtype) ? implode(', ', $idtype) : var_export($idtype, true), implode(', ', \Pixelboxx\EnumType\IDType::getValidValues())), __LINE__);
        }
        $this->idtype = $idtype;
        return $this;
    }
    /**
     * Get subfolders value
     * @return bool|null
     */
    public function getSubfolders()
    {
        return $this->subfolders;
    }
    /**
     * Set subfolders value
     * @param bool $subfolders
     * @return \Pixelboxx\StructType\DataSpecificationType
     */
    public function setSubfolders($subfolders = false)
    {
        // validation for constraint: boolean
        if (!is_null($subfolders) && !is_bool($subfolders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subfolders, true), gettype($subfolders)), __LINE__);
        }
        $this->subfolders = $subfolders;
        return $this;
    }
    /**
     * Get parentfolders value
     * @return bool|null
     */
    public function getParentfolders()
    {
        return $this->parentfolders;
    }
    /**
     * Set parentfolders value
     * @param bool $parentfolders
     * @return \Pixelboxx\StructType\DataSpecificationType
     */
    public function setParentfolders($parentfolders = false)
    {
        // validation for constraint: boolean
        if (!is_null($parentfolders) && !is_bool($parentfolders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($parentfolders, true), gettype($parentfolders)), __LINE__);
        }
        $this->parentfolders = $parentfolders;
        return $this;
    }
}
