<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Content StructType
 * @subpackage Structs
 */
class Content extends AbstractStructBase
{
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: pb:Item
     * @var \Pixelboxx\StructType\ItemType[]
     */
    public $Item;
    /**
     * Constructor method for Content
     * @uses Content::setItem()
     * @param \Pixelboxx\StructType\ItemType[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * @return \Pixelboxx\StructType\ItemType[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contentItemItem) {
            // validation for constraint: itemType
            if (!$contentItemItem instanceof \Pixelboxx\StructType\ItemType) {
                $invalidValues[] = is_object($contentItemItem) ? get_class($contentItemItem) : sprintf('%s(%s)', gettype($contentItemItem), var_export($contentItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \Pixelboxx\StructType\ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ItemType[] $item
     * @return \Pixelboxx\StructType\Content
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ItemType $item
     * @return \Pixelboxx\StructType\Content
     */
    public function addToItem(\Pixelboxx\StructType\ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\ItemType) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \Pixelboxx\StructType\ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
}
