<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonSearchParamType StructType
 * Meta information extracted from the WSDL
 * - documentation: Parameter für Suchanfragen, die sowohl bei einfacher Suche wie auch erweiterter Suche verwendet werden können. Dazu gehören FolderId (Mappe, in der gesucht werden soll), Order (Sortierreihenfolge), Range (Teilergebnis das
 * geliefert werden soll), WithMetadata (Metadaten die zu jedem Ergebnisobjekt geliefert werden sollen) WithRawData (Rohdaten die zu jedem Ergebnisobjekt geliefert werden sollen). Die maximale Anzahl gelieferter Ergebnisse ist serverseitig begrenzt, die
 * Obergrenze für Anfragen ohne Daten, mit Metadaten und mit Rohdaten kann unterschiedlich sein, ist jedoch mindestens 1.
 * @subpackage Structs
 */
class CommonSearchParamType extends AbstractStructBase
{
    /**
     * The SearchEngine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchEngine;
    /**
     * The FolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \S+
     * @var string
     */
    public $FolderId;
    /**
     * The OrderAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\OrderAttributesType
     */
    public $OrderAttributes;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Range
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\RangeType
     */
    public $Range;
    /**
     * The WithMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\MetadataRequestType
     */
    public $WithMetadata;
    /**
     * The WithRawData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\RawDataListRequestType
     */
    public $WithRawData;
    /**
     * The withFolders
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $withFolders;
    /**
     * The withObjects
     * Meta information extracted from the WSDL
     * - default: true
     * - use: optional
     * @var bool
     */
    public $withObjects;
    /**
     * Constructor method for CommonSearchParamType
     * @uses CommonSearchParamType::setSearchEngine()
     * @uses CommonSearchParamType::setFolderId()
     * @uses CommonSearchParamType::setOrderAttributes()
     * @uses CommonSearchParamType::setOrder()
     * @uses CommonSearchParamType::setRange()
     * @uses CommonSearchParamType::setWithMetadata()
     * @uses CommonSearchParamType::setWithRawData()
     * @uses CommonSearchParamType::setWithFolders()
     * @uses CommonSearchParamType::setWithObjects()
     * @param string $searchEngine
     * @param string $folderId
     * @param \Pixelboxx\StructType\OrderAttributesType $orderAttributes
     * @param string $order
     * @param \Pixelboxx\StructType\RangeType $range
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @param \Pixelboxx\StructType\RawDataListRequestType $withRawData
     * @param bool $withFolders
     * @param bool $withObjects
     */
    public function __construct($searchEngine = null, $folderId = null, \Pixelboxx\StructType\OrderAttributesType $orderAttributes = null, $order = null, \Pixelboxx\StructType\RangeType $range = null, \Pixelboxx\StructType\MetadataRequestType $withMetadata = null, \Pixelboxx\StructType\RawDataListRequestType $withRawData = null, $withFolders = false, $withObjects = true)
    {
        $this
            ->setSearchEngine($searchEngine)
            ->setFolderId($folderId)
            ->setOrderAttributes($orderAttributes)
            ->setOrder($order)
            ->setRange($range)
            ->setWithMetadata($withMetadata)
            ->setWithRawData($withRawData)
            ->setWithFolders($withFolders)
            ->setWithObjects($withObjects);
    }
    /**
     * Get SearchEngine value
     * @return string|null
     */
    public function getSearchEngine()
    {
        return $this->SearchEngine;
    }
    /**
     * Set SearchEngine value
     * @uses \Pixelboxx\EnumType\SearchEngineType::valueIsValid()
     * @uses \Pixelboxx\EnumType\SearchEngineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchEngine
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setSearchEngine($searchEngine = null)
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\SearchEngineType::valueIsValid($searchEngine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\SearchEngineType', is_array($searchEngine) ? implode(', ', $searchEngine) : var_export($searchEngine, true), implode(', ', \Pixelboxx\EnumType\SearchEngineType::getValidValues())), __LINE__);
        }
        $this->SearchEngine = $searchEngine;
        return $this;
    }
    /**
     * Get FolderId value
     * @return string|null
     */
    public function getFolderId()
    {
        return $this->FolderId;
    }
    /**
     * Set FolderId value
     * @param string $folderId
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setFolderId($folderId = null)
    {
        // validation for constraint: string
        if (!is_null($folderId) && !is_string($folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folderId, true), gettype($folderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($folderId) && !preg_match('/\\S+/', $folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($folderId, true)), __LINE__);
        }
        $this->FolderId = $folderId;
        return $this;
    }
    /**
     * Get OrderAttributes value
     * @return \Pixelboxx\StructType\OrderAttributesType|null
     */
    public function getOrderAttributes()
    {
        return $this->OrderAttributes;
    }
    /**
     * Set OrderAttributes value
     * @param \Pixelboxx\StructType\OrderAttributesType $orderAttributes
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setOrderAttributes(\Pixelboxx\StructType\OrderAttributesType $orderAttributes = null)
    {
        $this->OrderAttributes = $orderAttributes;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @uses \Pixelboxx\EnumType\OrderType::valueIsValid()
     * @uses \Pixelboxx\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $order
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\OrderType::valueIsValid($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\OrderType', is_array($order) ? implode(', ', $order) : var_export($order, true), implode(', ', \Pixelboxx\EnumType\OrderType::getValidValues())), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Range value
     * @return \Pixelboxx\StructType\RangeType|null
     */
    public function getRange()
    {
        return $this->Range;
    }
    /**
     * Set Range value
     * @param \Pixelboxx\StructType\RangeType $range
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setRange(\Pixelboxx\StructType\RangeType $range = null)
    {
        $this->Range = $range;
        return $this;
    }
    /**
     * Get WithMetadata value
     * @return \Pixelboxx\StructType\MetadataRequestType|null
     */
    public function getWithMetadata()
    {
        return $this->WithMetadata;
    }
    /**
     * Set WithMetadata value
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setWithMetadata(\Pixelboxx\StructType\MetadataRequestType $withMetadata = null)
    {
        $this->WithMetadata = $withMetadata;
        return $this;
    }
    /**
     * Get WithRawData value
     * @return \Pixelboxx\StructType\RawDataListRequestType|null
     */
    public function getWithRawData()
    {
        return $this->WithRawData;
    }
    /**
     * Set WithRawData value
     * @param \Pixelboxx\StructType\RawDataListRequestType $withRawData
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setWithRawData(\Pixelboxx\StructType\RawDataListRequestType $withRawData = null)
    {
        $this->WithRawData = $withRawData;
        return $this;
    }
    /**
     * Get withFolders value
     * @return bool|null
     */
    public function getWithFolders()
    {
        return $this->withFolders;
    }
    /**
     * Set withFolders value
     * @param bool $withFolders
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setWithFolders($withFolders = false)
    {
        // validation for constraint: boolean
        if (!is_null($withFolders) && !is_bool($withFolders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withFolders, true), gettype($withFolders)), __LINE__);
        }
        $this->withFolders = $withFolders;
        return $this;
    }
    /**
     * Get withObjects value
     * @return bool|null
     */
    public function getWithObjects()
    {
        return $this->withObjects;
    }
    /**
     * Set withObjects value
     * @param bool $withObjects
     * @return \Pixelboxx\StructType\CommonSearchParamType
     */
    public function setWithObjects($withObjects = true)
    {
        // validation for constraint: boolean
        if (!is_null($withObjects) && !is_bool($withObjects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withObjects, true), gettype($withObjects)), __LINE__);
        }
        $this->withObjects = $withObjects;
        return $this;
    }
}
