<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddObjectToFolderRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Fügt das Objekt mit der angegebenen ObjectId dem Folder mit der angegebenen FolderId hinzu. Der Aufruf ist simulierbar.
 * @subpackage Structs
 */
class AddObjectToFolderRequestType extends AbstractStructBase
{
    /**
     * The FolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $FolderId;
    /**
     * The ObjectId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $ObjectId;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * Constructor method for AddObjectToFolderRequestType
     * @uses AddObjectToFolderRequestType::setFolderId()
     * @uses AddObjectToFolderRequestType::setObjectId()
     * @uses AddObjectToFolderRequestType::setSimulate()
     * @param string $folderId
     * @param string $objectId
     * @param bool $simulate
     */
    public function __construct($folderId = null, $objectId = null, $simulate = false)
    {
        $this
            ->setFolderId($folderId)
            ->setObjectId($objectId)
            ->setSimulate($simulate);
    }
    /**
     * Get FolderId value
     * @return string|null
     */
    public function getFolderId()
    {
        return $this->FolderId;
    }
    /**
     * Set FolderId value
     * @param string $folderId
     * @return \Pixelboxx\StructType\AddObjectToFolderRequestType
     */
    public function setFolderId($folderId = null)
    {
        // validation for constraint: string
        if (!is_null($folderId) && !is_string($folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folderId, true), gettype($folderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($folderId) && !preg_match('/\\S+/', $folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($folderId, true)), __LINE__);
        }
        $this->FolderId = $folderId;
        return $this;
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \Pixelboxx\StructType\AddObjectToFolderRequestType
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($objectId) && !preg_match('/\\S+/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($objectId, true)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\AddObjectToFolderRequestType
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
}
