<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\UpdateObjectRequest $updateObjectRequest
     * @return \Pixelboxx\StructType\SuccessMessageResponse|bool
     */
    public function updateObject(\Pixelboxx\StructType\UpdateObjectRequest $updateObjectRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->updateObject($updateObjectRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUsageList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\UpdateUsageListRequest $updateUsageListRequest
     * @return \Pixelboxx\StructType\SuccessMessageResponse|bool
     */
    public function updateUsageList(\Pixelboxx\StructType\UpdateUsageListRequest $updateUsageListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUsageList($updateUsageListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\SuccessMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
