<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named removeObjectFromFolder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\RemoveObjectFromFolderRequest $removeObjectFromFolderRequest
     * @return \Pixelboxx\StructType\SuccessMessageResponse|bool
     */
    public function removeObjectFromFolder(\Pixelboxx\StructType\RemoveObjectFromFolderRequest $removeObjectFromFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->removeObjectFromFolder($removeObjectFromFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\SuccessMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
