<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\GetObjectRequest $getObjectRequest
     * @return \Pixelboxx\StructType\ObjectResponse|bool
     */
    public function getObject(\Pixelboxx\StructType\GetObjectRequest $getObjectRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getObject($getObjectRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUsageList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\GetUsageListRequest $getUsageListRequest
     * @return \Pixelboxx\StructType\GetUsageListResponse|bool
     */
    public function getUsageList(\Pixelboxx\StructType\GetUsageListRequest $getUsageListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getUsageList($getUsageListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFolderStructure
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\GetFolderStructureRequest $getFolderStructureRequest
     * @return \Pixelboxx\StructType\FolderStructureResponse|bool
     */
    public function getFolderStructure(\Pixelboxx\StructType\GetFolderStructureRequest $getFolderStructureRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getFolderStructure($getFolderStructureRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFolder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\GetFolderRequest $getFolderRequest
     * @return \Pixelboxx\StructType\FolderResponse|bool
     */
    public function getFolder(\Pixelboxx\StructType\GetFolderRequest $getFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getFolder($getFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTypeInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\GetTypeInfoRequest $getTypeInfoRequest
     * @return \Pixelboxx\StructType\GetTypeInfoResponse|bool
     */
    public function getTypeInfo(\Pixelboxx\StructType\GetTypeInfoRequest $getTypeInfoRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getTypeInfo($getTypeInfoRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\FolderResponse|\Pixelboxx\StructType\FolderStructureResponse|\Pixelboxx\StructType\GetTypeInfoResponse|\Pixelboxx\StructType\GetUsageListResponse|\Pixelboxx\StructType\ObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
