<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\CreateObjectRequest $createObjectRequest
     * @return \Pixelboxx\StructType\ObjectResponse|bool
     */
    public function createObject(\Pixelboxx\StructType\CreateObjectRequest $createObjectRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->createObject($createObjectRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createFolder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\CreateFolderRequest $createFolderRequest
     * @return \Pixelboxx\StructType\FolderResponse|bool
     */
    public function createFolder(\Pixelboxx\StructType\CreateFolderRequest $createFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->createFolder($createFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\FolderResponse|\Pixelboxx\StructType\ObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
