<?php

namespace Pixelboxx\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SearchEngineType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Für die explizite Angabe einer Searchengine. Ist "Pixelboxx" angegeben, kann der SolrQueryTerm nicht verwendet werden. Im Falle von "Solr" ist es z.Zt nicht möglich, StringTerm und XLinkTerm zu verwenden, insbesondere keine
 * Abfragen, die Beziehungen zwischen mehreren Objekten über "ref" definieren. Der SolrQueryTerm ist eine vollständige Solr-Suchanfrage und kann nur alleinstehend verwendet werden.
 * @subpackage Enumerations
 */
class SearchEngineType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Pixelboxx'
     * @return string 'Pixelboxx'
     */
    const VALUE_PIXELBOXX = 'Pixelboxx';
    /**
     * Constant for value 'Solr'
     * @return string 'Solr'
     */
    const VALUE_SOLR = 'Solr';
    /**
     * Return allowed values
     * @uses self::VALUE_PIXELBOXX
     * @uses self::VALUE_SOLR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PIXELBOXX,
            self::VALUE_SOLR,
        );
    }
}
