<?php

namespace Pixelboxx\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RDType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Typ für Rohdaten, Möglichkeiten: Feindaten, Layoutdaten, Thumbnails oder freie Definition (custom). Bei einem Datenimport werden grundsätzlich die Feindaten importiert, dies ist stets die unskalierte unmodifizierte Form der
 * Rohdaten. Layoutdaten und Thumbnaildaten entstehen durch Umwandlung der Rohdaten in JPEG und Skalierung auf eine feste Größe. Alle anderen Konvertierungen oder Skalierungen sind als "custom" anzugeben.
 * @subpackage Enumerations
 */
class RDType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'thumb'
     * @return string 'thumb'
     */
    const VALUE_THUMB = 'thumb';
    /**
     * Constant for value 'layout'
     * @return string 'layout'
     */
    const VALUE_LAYOUT = 'layout';
    /**
     * Constant for value 'fine'
     * @return string 'fine'
     */
    const VALUE_FINE = 'fine';
    /**
     * Constant for value 'custom'
     * @return string 'custom'
     */
    const VALUE_CUSTOM = 'custom';
    /**
     * Constant for value 'lowres'
     * @return string 'lowres'
     */
    const VALUE_LOWRES = 'lowres';
    /**
     * Return allowed values
     * @uses self::VALUE_THUMB
     * @uses self::VALUE_LAYOUT
     * @uses self::VALUE_FINE
     * @uses self::VALUE_CUSTOM
     * @uses self::VALUE_LOWRES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_THUMB,
            self::VALUE_LAYOUT,
            self::VALUE_FINE,
            self::VALUE_CUSTOM,
            self::VALUE_LOWRES,
        );
    }
}
