<?php

namespace Pixelboxx\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for IDType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identificator type used to locate object. All Services support identification by Object ID (Value: oid) or by Data Object ID (Value: doi). Default id type is 'doi'. Id types other than doi are used in responses only when request id
 * type differs from doi. Some services may support custom identification types. Please see service documentation for details.
 * @subpackage Enumerations
 */
class IDType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'doi'
     * @return string 'doi'
     */
    const VALUE_DOI = 'doi';
    /**
     * Constant for value 'oid'
     * @return string 'oid'
     */
    const VALUE_OID = 'oid';
    /**
     * Constant for value 'filename'
     * @return string 'filename'
     */
    const VALUE_FILENAME = 'filename';
    /**
     * Constant for value 'customid'
     * @return string 'customid'
     */
    const VALUE_CUSTOMID = 'customid';
    /**
     * Return allowed values
     * @uses self::VALUE_DOI
     * @uses self::VALUE_OID
     * @uses self::VALUE_FILENAME
     * @uses self::VALUE_CUSTOMID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DOI,
            self::VALUE_OID,
            self::VALUE_FILENAME,
            self::VALUE_CUSTOMID,
        );
    }
}
