<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLinkRefsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Erzeugt eine Verknüpfung von einem Quellobjekt zu einem Zielobjekt.
 * @subpackage Structs
 */
class XLinkRefsType extends AbstractStructBase
{
    /**
     * The ref
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \S+
     * @var string
     */
    public $ref;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The rel
     * Meta information extracted from the WSDL
     * - default: child
     * - use: optional
     * @var string
     */
    public $rel;
    /**
     * Constructor method for XLinkRefsType
     * @uses XLinkRefsType::setRef()
     * @uses XLinkRefsType::setType()
     * @uses XLinkRefsType::setRel()
     * @param string $ref
     * @param string $type
     * @param string $rel
     */
    public function __construct($ref = null, $type = null, $rel = 'child')
    {
        $this
            ->setRef($ref)
            ->setType($type)
            ->setRel($rel);
    }
    /**
     * Get ref value
     * @return string
     */
    public function getRef()
    {
        return $this->ref;
    }
    /**
     * Set ref value
     * @param string $ref
     * @return \Pixelboxx\StructType\XLinkRefsType
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($ref) && !preg_match('/\\S+/', $ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($ref, true)), __LINE__);
        }
        $this->ref = $ref;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Pixelboxx\StructType\XLinkRefsType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get rel value
     * @return string|null
     */
    public function getRel()
    {
        return $this->rel;
    }
    /**
     * Set rel value
     * @uses \Pixelboxx\EnumType\XLinkRelationType::valueIsValid()
     * @uses \Pixelboxx\EnumType\XLinkRelationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rel
     * @return \Pixelboxx\StructType\XLinkRefsType
     */
    public function setRel($rel = 'child')
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\XLinkRelationType::valueIsValid($rel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\XLinkRelationType', is_array($rel) ? implode(', ', $rel) : var_export($rel, true), implode(', ', \Pixelboxx\EnumType\XLinkRelationType::getValidValues())), __LINE__);
        }
        $this->rel = $rel;
        return $this;
    }
}
