<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLinkObjectsType StructType
 * @subpackage Structs
 */
class XLinkObjectsType extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: pb:Object
     * @var \Pixelboxx\StructType\ObjectType[]
     */
    public $Object;
    /**
     * The rel
     * Meta information extracted from the WSDL
     * - default: child
     * - use: optional
     * @var string
     */
    public $rel;
    /**
     * Constructor method for XLinkObjectsType
     * @uses XLinkObjectsType::setType()
     * @uses XLinkObjectsType::setObject()
     * @uses XLinkObjectsType::setRel()
     * @param string $type
     * @param \Pixelboxx\StructType\ObjectType[] $object
     * @param string $rel
     */
    public function __construct($type = null, array $object = array(), $rel = 'child')
    {
        $this
            ->setType($type)
            ->setObject($object)
            ->setRel($rel);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Pixelboxx\StructType\XLinkObjectsType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get Object value
     * @return \Pixelboxx\StructType\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * This method is responsible for validating the values passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectForArrayConstraintsFromSetObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xLinkObjectsTypeObjectItem) {
            // validation for constraint: itemType
            if (!$xLinkObjectsTypeObjectItem instanceof \Pixelboxx\StructType\ObjectType) {
                $invalidValues[] = is_object($xLinkObjectsTypeObjectItem) ? get_class($xLinkObjectsTypeObjectItem) : sprintf('%s(%s)', gettype($xLinkObjectsTypeObjectItem), var_export($xLinkObjectsTypeObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Object property can only contain items of type \Pixelboxx\StructType\ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ObjectType[] $object
     * @return \Pixelboxx\StructType\XLinkObjectsType
     */
    public function setObject(array $object = array())
    {
        // validation for constraint: array
        if ('' !== ($objectArrayErrorMessage = self::validateObjectForArrayConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectArrayErrorMessage, __LINE__);
        }
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ObjectType $item
     * @return \Pixelboxx\StructType\XLinkObjectsType
     */
    public function addToObject(\Pixelboxx\StructType\ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Object property can only contain items of type \Pixelboxx\StructType\ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get rel value
     * @return string|null
     */
    public function getRel()
    {
        return $this->rel;
    }
    /**
     * Set rel value
     * @uses \Pixelboxx\EnumType\XLinkRelationType::valueIsValid()
     * @uses \Pixelboxx\EnumType\XLinkRelationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rel
     * @return \Pixelboxx\StructType\XLinkObjectsType
     */
    public function setRel($rel = 'child')
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\XLinkRelationType::valueIsValid($rel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\XLinkRelationType', is_array($rel) ? implode(', ', $rel) : var_export($rel, true), implode(', ', \Pixelboxx\EnumType\XLinkRelationType::getValidValues())), __LINE__);
        }
        $this->rel = $rel;
        return $this;
    }
}
