<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueFacetType StructType
 * Meta information extracted from the WSDL
 * - documentation: Facet with a single value.
 * @subpackage Structs
 */
class ValueFacetType extends AbstractFacetType
{
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ValueFacetType
     * @uses ValueFacetType::setValue()
     * @param string $value
     */
    public function __construct($value = null)
    {
        $this
            ->setValue($value);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Pixelboxx\StructType\ValueFacetType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
