<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsageListEntryType StructType
 * Meta information extracted from the WSDL
 * - documentation: A usage list entry for the "updateUsageList" requests. Remarks: Update requests for the operations "update" and "delete" require the attribute "id", while "insert" does not.
 * @subpackage Structs
 */
class UsageListEntryType extends AbstractStructBase
{
    /**
     * The usageInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $usageInfo;
    /**
     * The operation
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $operation;
    /**
     * The identifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identifier;
    /**
     * The contactMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contactMail;
    /**
     * The callbackUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callbackUrl;
    /**
     * The extendedUsageInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $extendedUsageInfo;
    /**
     * The medium
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $medium;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $id;
    /**
     * Constructor method for UsageListEntryType
     * @uses UsageListEntryType::setUsageInfo()
     * @uses UsageListEntryType::setOperation()
     * @uses UsageListEntryType::setIdentifier()
     * @uses UsageListEntryType::setContactMail()
     * @uses UsageListEntryType::setCallbackUrl()
     * @uses UsageListEntryType::setExtendedUsageInfo()
     * @uses UsageListEntryType::setMedium()
     * @uses UsageListEntryType::setEndDate()
     * @uses UsageListEntryType::setId()
     * @param string $usageInfo
     * @param string $operation
     * @param string $identifier
     * @param string $contactMail
     * @param string $callbackUrl
     * @param string $extendedUsageInfo
     * @param string $medium
     * @param string $endDate
     * @param int $id
     */
    public function __construct($usageInfo = null, $operation = null, $identifier = null, $contactMail = null, $callbackUrl = null, $extendedUsageInfo = null, $medium = null, $endDate = null, $id = null)
    {
        $this
            ->setUsageInfo($usageInfo)
            ->setOperation($operation)
            ->setIdentifier($identifier)
            ->setContactMail($contactMail)
            ->setCallbackUrl($callbackUrl)
            ->setExtendedUsageInfo($extendedUsageInfo)
            ->setMedium($medium)
            ->setEndDate($endDate)
            ->setId($id);
    }
    /**
     * Get usageInfo value
     * @return string
     */
    public function getUsageInfo()
    {
        return $this->usageInfo;
    }
    /**
     * Set usageInfo value
     * @param string $usageInfo
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setUsageInfo($usageInfo = null)
    {
        // validation for constraint: string
        if (!is_null($usageInfo) && !is_string($usageInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usageInfo, true), gettype($usageInfo)), __LINE__);
        }
        $this->usageInfo = $usageInfo;
        return $this;
    }
    /**
     * Get operation value
     * @return string
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @uses \Pixelboxx\EnumType\OperationType::valueIsValid()
     * @uses \Pixelboxx\EnumType\OperationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\OperationType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\OperationType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \Pixelboxx\EnumType\OperationType::getValidValues())), __LINE__);
        }
        $this->operation = $operation;
        return $this;
    }
    /**
     * Get identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param string $identifier
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get contactMail value
     * @return string|null
     */
    public function getContactMail()
    {
        return $this->contactMail;
    }
    /**
     * Set contactMail value
     * @param string $contactMail
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setContactMail($contactMail = null)
    {
        // validation for constraint: string
        if (!is_null($contactMail) && !is_string($contactMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactMail, true), gettype($contactMail)), __LINE__);
        }
        $this->contactMail = $contactMail;
        return $this;
    }
    /**
     * Get callbackUrl value
     * @return string|null
     */
    public function getCallbackUrl()
    {
        return $this->callbackUrl;
    }
    /**
     * Set callbackUrl value
     * @param string $callbackUrl
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setCallbackUrl($callbackUrl = null)
    {
        // validation for constraint: string
        if (!is_null($callbackUrl) && !is_string($callbackUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callbackUrl, true), gettype($callbackUrl)), __LINE__);
        }
        $this->callbackUrl = $callbackUrl;
        return $this;
    }
    /**
     * Get extendedUsageInfo value
     * @return string|null
     */
    public function getExtendedUsageInfo()
    {
        return $this->extendedUsageInfo;
    }
    /**
     * Set extendedUsageInfo value
     * @param string $extendedUsageInfo
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setExtendedUsageInfo($extendedUsageInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extendedUsageInfo) && !is_string($extendedUsageInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedUsageInfo, true), gettype($extendedUsageInfo)), __LINE__);
        }
        $this->extendedUsageInfo = $extendedUsageInfo;
        return $this;
    }
    /**
     * Get medium value
     * @return string|null
     */
    public function getMedium()
    {
        return $this->medium;
    }
    /**
     * Set medium value
     * @uses \Pixelboxx\EnumType\MediumType::valueIsValid()
     * @uses \Pixelboxx\EnumType\MediumType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $medium
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setMedium($medium = null)
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\MediumType::valueIsValid($medium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\MediumType', is_array($medium) ? implode(', ', $medium) : var_export($medium, true), implode(', ', \Pixelboxx\EnumType\MediumType::getValidValues())), __LINE__);
        }
        $this->medium = $medium;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \Pixelboxx\StructType\UsageListEntryType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
}
