<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsageInfoResultType StructType
 * Meta information extracted from the WSDL
 * - documentation: A single usage information for a usage list entry
 * @subpackage Structs
 */
class UsageInfoResultType extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $id;
    /**
     * The key
     * @var string
     */
    public $key;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\DisplayNameType[]
     */
    public $displayName;
    /**
     * Constructor method for UsageInfoResultType
     * @uses UsageInfoResultType::setId()
     * @uses UsageInfoResultType::setKey()
     * @uses UsageInfoResultType::setDisplayName()
     * @param int $id
     * @param string $key
     * @param \Pixelboxx\StructType\DisplayNameType[] $displayName
     */
    public function __construct($id = null, $key = null, array $displayName = array())
    {
        $this
            ->setId($id)
            ->setKey($key)
            ->setDisplayName($displayName);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \Pixelboxx\StructType\UsageInfoResultType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Pixelboxx\StructType\UsageInfoResultType
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get displayName value
     * @return \Pixelboxx\StructType\DisplayNameType[]|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * This method is responsible for validating the values passed to the setDisplayName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisplayName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisplayNameForArrayConstraintsFromSetDisplayName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $usageInfoResultTypeDisplayNameItem) {
            // validation for constraint: itemType
            if (!$usageInfoResultTypeDisplayNameItem instanceof \Pixelboxx\StructType\DisplayNameType) {
                $invalidValues[] = is_object($usageInfoResultTypeDisplayNameItem) ? get_class($usageInfoResultTypeDisplayNameItem) : sprintf('%s(%s)', gettype($usageInfoResultTypeDisplayNameItem), var_export($usageInfoResultTypeDisplayNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The displayName property can only contain items of type \Pixelboxx\StructType\DisplayNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set displayName value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayNameType[] $displayName
     * @return \Pixelboxx\StructType\UsageInfoResultType
     */
    public function setDisplayName(array $displayName = array())
    {
        // validation for constraint: array
        if ('' !== ($displayNameArrayErrorMessage = self::validateDisplayNameForArrayConstraintsFromSetDisplayName($displayName))) {
            throw new \InvalidArgumentException($displayNameArrayErrorMessage, __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Add item to displayName value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayNameType $item
     * @return \Pixelboxx\StructType\UsageInfoResultType
     */
    public function addToDisplayName(\Pixelboxx\StructType\DisplayNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\DisplayNameType) {
            throw new \InvalidArgumentException(sprintf('The displayName property can only contain items of type \Pixelboxx\StructType\DisplayNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->displayName[] = $item;
        return $this;
    }
}
