<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateXLinkType StructType
 * Meta information extracted from the WSDL
 * - documentation: Definiert eine Verknüpfung zu einem Ziel-Objekt.
 * @subpackage Structs
 */
class UpdateXLinkType extends AbstractStructBase
{
    /**
     * The targetid
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \S+
     * @var string
     */
    public $targetid;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * Constructor method for UpdateXLinkType
     * @uses UpdateXLinkType::setTargetid()
     * @uses UpdateXLinkType::setType()
     * @param string $targetid
     * @param string $type
     */
    public function __construct($targetid = null, $type = null)
    {
        $this
            ->setTargetid($targetid)
            ->setType($type);
    }
    /**
     * Get targetid value
     * @return string
     */
    public function getTargetid()
    {
        return $this->targetid;
    }
    /**
     * Set targetid value
     * @param string $targetid
     * @return \Pixelboxx\StructType\UpdateXLinkType
     */
    public function setTargetid($targetid = null)
    {
        // validation for constraint: string
        if (!is_null($targetid) && !is_string($targetid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetid, true), gettype($targetid)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($targetid) && !preg_match('/\\S+/', $targetid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($targetid, true)), __LINE__);
        }
        $this->targetid = $targetid;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Pixelboxx\StructType\UpdateXLinkType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
