<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateObjectRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ändert Objektattribute für das Objekt mit der angegebenen ObjectId. Dabei enthält "Attributes" die Liste der Attribute mit ihren neuen Inhalten. Es werden nur die Attribute geändert, die angegeben sind. Ist/sind Sprachvarianten
 * angegeben, so werden bei mehrsprachigen Attributen nur die angegebenen Varianten geändert. Der Aufruf ist simulierbar.
 * @subpackage Structs
 */
class UpdateObjectRequest extends AbstractStructBase
{
    /**
     * The ObjectId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $ObjectId;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: pb:Attributes
     * @var \Pixelboxx\StructType\AttributeListType
     */
    public $Attributes;
    /**
     * The XLinks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\UpdateXLink
     */
    public $XLinks;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * The createnewversion
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $createnewversion;
    /**
     * Constructor method for UpdateObjectRequest
     * @uses UpdateObjectRequest::setObjectId()
     * @uses UpdateObjectRequest::setAttributes()
     * @uses UpdateObjectRequest::setXLinks()
     * @uses UpdateObjectRequest::setSimulate()
     * @uses UpdateObjectRequest::setCreatenewversion()
     * @param string $objectId
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @param \Pixelboxx\StructType\UpdateXLink $xLinks
     * @param bool $simulate
     * @param bool $createnewversion
     */
    public function __construct($objectId = null, \Pixelboxx\StructType\AttributeListType $attributes = null, \Pixelboxx\StructType\UpdateXLink $xLinks = null, $simulate = false, $createnewversion = false)
    {
        $this
            ->setObjectId($objectId)
            ->setAttributes($attributes)
            ->setXLinks($xLinks)
            ->setSimulate($simulate)
            ->setCreatenewversion($createnewversion);
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \Pixelboxx\StructType\UpdateObjectRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($objectId) && !preg_match('/\\S+/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($objectId, true)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \Pixelboxx\StructType\AttributeListType|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @return \Pixelboxx\StructType\UpdateObjectRequest
     */
    public function setAttributes(\Pixelboxx\StructType\AttributeListType $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get XLinks value
     * @return \Pixelboxx\StructType\UpdateXLink|null
     */
    public function getXLinks()
    {
        return $this->XLinks;
    }
    /**
     * Set XLinks value
     * @param \Pixelboxx\StructType\UpdateXLink $xLinks
     * @return \Pixelboxx\StructType\UpdateObjectRequest
     */
    public function setXLinks(\Pixelboxx\StructType\UpdateXLink $xLinks = null)
    {
        $this->XLinks = $xLinks;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\UpdateObjectRequest
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
    /**
     * Get createnewversion value
     * @return bool|null
     */
    public function getCreatenewversion()
    {
        return $this->createnewversion;
    }
    /**
     * Set createnewversion value
     * @param bool $createnewversion
     * @return \Pixelboxx\StructType\UpdateObjectRequest
     */
    public function setCreatenewversion($createnewversion = false)
    {
        // validation for constraint: boolean
        if (!is_null($createnewversion) && !is_bool($createnewversion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createnewversion, true), gettype($createnewversion)), __LINE__);
        }
        $this->createnewversion = $createnewversion;
        return $this;
    }
}
