<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einem Objekt-Typ. Zur Zeit eine Liste mit den Namen aller Attribute. Der Mime-Type steht im Attribut "name".
 * @subpackage Structs
 */
class TypeInfoType extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\AttributeUsageType[]
     */
    public $Attribute;
    /**
     * Constructor method for TypeInfoType
     * @uses TypeInfoType::setType()
     * @uses TypeInfoType::setAttribute()
     * @param string $type
     * @param \Pixelboxx\StructType\AttributeUsageType[] $attribute
     */
    public function __construct($type = null, array $attribute = array())
    {
        $this
            ->setType($type)
            ->setAttribute($attribute);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Pixelboxx\StructType\TypeInfoType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get Attribute value
     * @return \Pixelboxx\StructType\AttributeUsageType[]|null
     */
    public function getAttribute()
    {
        return $this->Attribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $typeInfoTypeAttributeItem) {
            // validation for constraint: itemType
            if (!$typeInfoTypeAttributeItem instanceof \Pixelboxx\StructType\AttributeUsageType) {
                $invalidValues[] = is_object($typeInfoTypeAttributeItem) ? get_class($typeInfoTypeAttributeItem) : sprintf('%s(%s)', gettype($typeInfoTypeAttributeItem), var_export($typeInfoTypeAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attribute property can only contain items of type \Pixelboxx\StructType\AttributeUsageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attribute value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\AttributeUsageType[] $attribute
     * @return \Pixelboxx\StructType\TypeInfoType
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        $this->Attribute = $attribute;
        return $this;
    }
    /**
     * Add item to Attribute value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\AttributeUsageType $item
     * @return \Pixelboxx\StructType\TypeInfoType
     */
    public function addToAttribute(\Pixelboxx\StructType\AttributeUsageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\AttributeUsageType) {
            throw new \InvalidArgumentException(sprintf('The Attribute property can only contain items of type \Pixelboxx\StructType\AttributeUsageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attribute[] = $item;
        return $this;
    }
}
