<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Result of a search request, may contain grouped facets (if facets were specified in the search request) in addition to the actual search result (the items found).
 * @subpackage Structs
 */
class SearchResponse extends AbstractStructBase
{
    /**
     * The SearchResult
     * @var \Pixelboxx\StructType\SearchResultContentType
     */
    public $SearchResult;
    /**
     * The FacetGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\FacetGroupType[]
     */
    public $FacetGroup;
    /**
     * Constructor method for SearchResponse
     * @uses SearchResponse::setSearchResult()
     * @uses SearchResponse::setFacetGroup()
     * @param \Pixelboxx\StructType\SearchResultContentType $searchResult
     * @param \Pixelboxx\StructType\FacetGroupType[] $facetGroup
     */
    public function __construct(\Pixelboxx\StructType\SearchResultContentType $searchResult = null, array $facetGroup = array())
    {
        $this
            ->setSearchResult($searchResult)
            ->setFacetGroup($facetGroup);
    }
    /**
     * Get SearchResult value
     * @return \Pixelboxx\StructType\SearchResultContentType|null
     */
    public function getSearchResult()
    {
        return $this->SearchResult;
    }
    /**
     * Set SearchResult value
     * @param \Pixelboxx\StructType\SearchResultContentType $searchResult
     * @return \Pixelboxx\StructType\SearchResponse
     */
    public function setSearchResult(\Pixelboxx\StructType\SearchResultContentType $searchResult = null)
    {
        $this->SearchResult = $searchResult;
        return $this;
    }
    /**
     * Get FacetGroup value
     * @return \Pixelboxx\StructType\FacetGroupType[]|null
     */
    public function getFacetGroup()
    {
        return $this->FacetGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setFacetGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFacetGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFacetGroupForArrayConstraintsFromSetFacetGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchResponseFacetGroupItem) {
            // validation for constraint: itemType
            if (!$searchResponseFacetGroupItem instanceof \Pixelboxx\StructType\FacetGroupType) {
                $invalidValues[] = is_object($searchResponseFacetGroupItem) ? get_class($searchResponseFacetGroupItem) : sprintf('%s(%s)', gettype($searchResponseFacetGroupItem), var_export($searchResponseFacetGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FacetGroup property can only contain items of type \Pixelboxx\StructType\FacetGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FacetGroup value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FacetGroupType[] $facetGroup
     * @return \Pixelboxx\StructType\SearchResponse
     */
    public function setFacetGroup(array $facetGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($facetGroupArrayErrorMessage = self::validateFacetGroupForArrayConstraintsFromSetFacetGroup($facetGroup))) {
            throw new \InvalidArgumentException($facetGroupArrayErrorMessage, __LINE__);
        }
        $this->FacetGroup = $facetGroup;
        return $this;
    }
    /**
     * Add item to FacetGroup value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FacetGroupType $item
     * @return \Pixelboxx\StructType\SearchResponse
     */
    public function addToFacetGroup(\Pixelboxx\StructType\FacetGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\FacetGroupType) {
            throw new \InvalidArgumentException(sprintf('The FacetGroup property can only contain items of type \Pixelboxx\StructType\FacetGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FacetGroup[] = $item;
        return $this;
    }
}
