<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Search request, basically the SearchTerm and some common search parameters (Searchengine, requested range etc.) The search request may contain (specific or unspecific) requirements for facets. Specific requirements will restict the
 * search to the given facet specifications. Faceted search is only implemented for the Solr searchengine. If LabelLanguages are specified, the returned FacetGroups and Facets will contain the existing labels in these languages.
 * @subpackage Structs
 */
class SearchRequest extends AbstractStructBase
{
    /**
     * The SearchParams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\CommonSearchParamType
     */
    public $SearchParams;
    /**
     * The SearchTerm
     * Meta information extracted from the WSDL
     * - ref: pb:SearchTerm
     * @var \Pixelboxx\StructType\SearchTerm
     */
    public $SearchTerm;
    /**
     * The Facet
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\FacetSpecType[]
     */
    public $Facet;
    /**
     * The LabelLanguages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\LanguageRequestType
     */
    public $LabelLanguages;
    /**
     * Constructor method for SearchRequest
     * @uses SearchRequest::setSearchParams()
     * @uses SearchRequest::setSearchTerm()
     * @uses SearchRequest::setFacet()
     * @uses SearchRequest::setLabelLanguages()
     * @param \Pixelboxx\StructType\CommonSearchParamType $searchParams
     * @param \Pixelboxx\StructType\SearchTerm $searchTerm
     * @param \Pixelboxx\StructType\FacetSpecType[] $facet
     * @param \Pixelboxx\StructType\LanguageRequestType $labelLanguages
     */
    public function __construct(\Pixelboxx\StructType\CommonSearchParamType $searchParams = null, \Pixelboxx\StructType\SearchTerm $searchTerm = null, array $facet = array(), \Pixelboxx\StructType\LanguageRequestType $labelLanguages = null)
    {
        $this
            ->setSearchParams($searchParams)
            ->setSearchTerm($searchTerm)
            ->setFacet($facet)
            ->setLabelLanguages($labelLanguages);
    }
    /**
     * Get SearchParams value
     * @return \Pixelboxx\StructType\CommonSearchParamType|null
     */
    public function getSearchParams()
    {
        return $this->SearchParams;
    }
    /**
     * Set SearchParams value
     * @param \Pixelboxx\StructType\CommonSearchParamType $searchParams
     * @return \Pixelboxx\StructType\SearchRequest
     */
    public function setSearchParams(\Pixelboxx\StructType\CommonSearchParamType $searchParams = null)
    {
        $this->SearchParams = $searchParams;
        return $this;
    }
    /**
     * Get SearchTerm value
     * @return \Pixelboxx\StructType\SearchTerm|null
     */
    public function getSearchTerm()
    {
        return $this->SearchTerm;
    }
    /**
     * Set SearchTerm value
     * @param \Pixelboxx\StructType\SearchTerm $searchTerm
     * @return \Pixelboxx\StructType\SearchRequest
     */
    public function setSearchTerm(\Pixelboxx\StructType\SearchTerm $searchTerm = null)
    {
        $this->SearchTerm = $searchTerm;
        return $this;
    }
    /**
     * Get Facet value
     * @return \Pixelboxx\StructType\FacetSpecType[]|null
     */
    public function getFacet()
    {
        return $this->Facet;
    }
    /**
     * This method is responsible for validating the values passed to the setFacet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFacet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFacetForArrayConstraintsFromSetFacet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchRequestFacetItem) {
            // validation for constraint: itemType
            if (!$searchRequestFacetItem instanceof \Pixelboxx\StructType\FacetSpecType) {
                $invalidValues[] = is_object($searchRequestFacetItem) ? get_class($searchRequestFacetItem) : sprintf('%s(%s)', gettype($searchRequestFacetItem), var_export($searchRequestFacetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Facet property can only contain items of type \Pixelboxx\StructType\FacetSpecType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Facet value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FacetSpecType[] $facet
     * @return \Pixelboxx\StructType\SearchRequest
     */
    public function setFacet(array $facet = array())
    {
        // validation for constraint: array
        if ('' !== ($facetArrayErrorMessage = self::validateFacetForArrayConstraintsFromSetFacet($facet))) {
            throw new \InvalidArgumentException($facetArrayErrorMessage, __LINE__);
        }
        $this->Facet = $facet;
        return $this;
    }
    /**
     * Add item to Facet value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FacetSpecType $item
     * @return \Pixelboxx\StructType\SearchRequest
     */
    public function addToFacet(\Pixelboxx\StructType\FacetSpecType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\FacetSpecType) {
            throw new \InvalidArgumentException(sprintf('The Facet property can only contain items of type \Pixelboxx\StructType\FacetSpecType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Facet[] = $item;
        return $this;
    }
    /**
     * Get LabelLanguages value
     * @return \Pixelboxx\StructType\LanguageRequestType|null
     */
    public function getLabelLanguages()
    {
        return $this->LabelLanguages;
    }
    /**
     * Set LabelLanguages value
     * @param \Pixelboxx\StructType\LanguageRequestType $labelLanguages
     * @return \Pixelboxx\StructType\SearchRequest
     */
    public function setLabelLanguages(\Pixelboxx\StructType\LanguageRequestType $labelLanguages = null)
    {
        $this->LabelLanguages = $labelLanguages;
        return $this;
    }
}
