<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchInFolderType StructType
 * Meta information extracted from the WSDL
 * - documentation: recursive - Include subfolders
 * @subpackage Structs
 */
class SearchInFolderType extends AbstractStructBase
{
    /**
     * The Folder
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - pattern: \S+
     * @var string[]
     */
    public $Folder;
    /**
     * The ref
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ref;
    /**
     * The recursive
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $recursive;
    /**
     * Constructor method for SearchInFolderType
     * @uses SearchInFolderType::setFolder()
     * @uses SearchInFolderType::setRef()
     * @uses SearchInFolderType::setRecursive()
     * @param string[] $folder
     * @param string $ref
     * @param bool $recursive
     */
    public function __construct(array $folder = array(), $ref = null, $recursive = null)
    {
        $this
            ->setFolder($folder)
            ->setRef($ref)
            ->setRecursive($recursive);
    }
    /**
     * Get Folder value
     * @return string[]
     */
    public function getFolder()
    {
        return $this->Folder;
    }
    /**
     * This method is responsible for validating the values passed to the setFolder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFolder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFolderForArrayConstraintsFromSetFolder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchInFolderTypeFolderItem) {
            // validation for constraint: itemType
            if (!is_string($searchInFolderTypeFolderItem)) {
                $invalidValues[] = is_object($searchInFolderTypeFolderItem) ? get_class($searchInFolderTypeFolderItem) : sprintf('%s(%s)', gettype($searchInFolderTypeFolderItem), var_export($searchInFolderTypeFolderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Folder property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Folder value
     * @throws \InvalidArgumentException
     * @param string[] $folder
     * @return \Pixelboxx\StructType\SearchInFolderType
     */
    public function setFolder(array $folder = array())
    {
        // validation for constraint: array
        if ('' !== ($folderArrayErrorMessage = self::validateFolderForArrayConstraintsFromSetFolder($folder))) {
            throw new \InvalidArgumentException($folderArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($folder) && !preg_match('/\\S+/', $folder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($folder, true)), __LINE__);
        }
        $this->Folder = $folder;
        return $this;
    }
    /**
     * Add item to Folder value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pixelboxx\StructType\SearchInFolderType
     */
    public function addToFolder($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Folder property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!preg_match('/\\S+/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($item, true)), __LINE__);
        }
        $this->Folder[] = $item;
        return $this;
    }
    /**
     * Get ref value
     * @return string|null
     */
    public function getRef()
    {
        return $this->ref;
    }
    /**
     * Set ref value
     * @param string $ref
     * @return \Pixelboxx\StructType\SearchInFolderType
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        $this->ref = $ref;
        return $this;
    }
    /**
     * Get recursive value
     * @return bool|null
     */
    public function getRecursive()
    {
        return $this->recursive;
    }
    /**
     * Set recursive value
     * @param bool $recursive
     * @return \Pixelboxx\StructType\SearchInFolderType
     */
    public function setRecursive($recursive = null)
    {
        // validation for constraint: boolean
        if (!is_null($recursive) && !is_bool($recursive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recursive, true), gettype($recursive)), __LINE__);
        }
        $this->recursive = $recursive;
        return $this;
    }
}
